package com.clx.performance.controller.pc;

import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.order.feign.OrderFeign;
import com.clx.order.params.OrderGoodsChildParams;
import com.clx.order.params.OrderGoodsParams;
import com.clx.order.params.PageCarrierOrderListParam;
import com.clx.order.params.PageOrderGoodsListParam;
import com.clx.order.vo.feign.FeignOrderVO;
import com.clx.order.vo.feign.FeignPageOrderVO;
import com.clx.performance.component.OrderGoodsIdGenerate;
import com.clx.performance.constant.RabbitKeyConstants;
import com.clx.performance.constant.RedisConstants;
import com.clx.performance.enums.OrderGoodsStatusEnum;
import com.clx.performance.mapper.OrderGoodsMapper;
import com.clx.performance.model.OrderGoods;
import com.clx.performance.service.OrderGoodsService;
import com.clx.performance.vo.pc.OrderGoodsVO;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import com.msl.common.utils.DateUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageBuilder;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * @ClassName GoodsOrderController
 * @Description
 * @Author kavin
 * @Date 2023/9/17 17:16
 * @Version 1.0
 */

@Slf4j
@RestController
@RequestMapping("/pc/goodsOrder")
@Validated
@Api(tags = "PC-货单")
public class GoodsOrderController {

    @Autowired
    OrderGoodsService orderGoodsService;

    @Autowired
    OrderGoodsMapper orderGoodsMapper;

    @Autowired
    private RabbitTemplate rabbitTemplate;

    @Autowired
    private RedissonClient redissonClient;

    @Autowired
    private OrderFeign orderFeign;

    @Autowired
    private OrderGoodsIdGenerate orderGoodsIdGenerate;

    @ApiOperation(value = "提交货单", notes = "<br>By:胡宇帆")
    @PostMapping("/saveGoodsOrder")
    public Result<Object> saveGoodName(@RequestBody @Validated OrderGoodsParams orderGoodsParams) {
        String orderNo = orderGoodsParams.getOrderNo();
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime sendLazyTime = null;
        //UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        RLock rLock = null;
        try {
            //1. 加分布式锁通过订单ID
            //获取锁
            rLock = redissonClient.getLock(RedisConstants.ORDER_NO_BLOCK + orderNo);
            //设置超时
            rLock.lock(1, TimeUnit.MINUTES);
            //2. 通过OrderNo 查询订单信息
            FeignOrderVO orderInfo = orderFeign.getOrderInfoFeign(orderNo);
            //1平台车辆 2部分平台车辆 3自有车辆
            Integer truckDemand = orderInfo.getTruckDemand();
            if (truckDemand != 3) {
                List<OrderGoodsChildParams> childParamsList = orderGoodsParams.getOrderGoodsChildParams();
                BigDecimal childSum = childParamsList.stream().map(OrderGoodsChildParams::getExtractWeight).reduce(
                        BigDecimal.ZERO, BigDecimal::add);
                if (orderInfo.getResidueWeight().compareTo(childSum) < 0) {
                    throw new RuntimeException("当前货单总吨数已超订单总吨数");
                }
                long beginOrderGoodsId = orderGoodsIdGenerate.getOrderGoodsId("pt", childParamsList.size());
                for (OrderGoodsChildParams child : childParamsList) {
                    if (child.getPendingOrderWay().equals(2) && child.getNeedTruckNum() == null) {
                        throw new RuntimeException("定向派单必须选择车辆");
                    }
                    OrderGoods orderGoods = new OrderGoods();
                    //提取吨数
                    orderGoods.setExtractWeight(child.getExtractWeight());
                    orderGoods.setResidueTransportWeight(child.getExtractWeight());
                    //提取方式 1提取全部 2提取部分
                    Integer extractWay = child.getExtractWay();
                    orderGoods.setExtractWay(extractWay);
                    //需要车辆
                    orderGoods.setNeedTruckNum(child.getNeedTruckNum());
                    //挂单方式
                    orderGoods.setPendingOrderWay(child.getPendingOrderWay());
                    //挂单时间
                    LocalDateTime postedTime = DateUtils.parseDateTime(child.getPendingOrderTime()).get();

                    if (sendLazyTime == null) {
                        sendLazyTime = postedTime;
                    } else if (sendLazyTime.isAfter(postedTime)) {
                        sendLazyTime = postedTime;
                    }

                    orderGoods.setPendingOrderTime(postedTime);
                    orderGoods.setPendingOrderFreight(child.getPendingOrderFreight());

                    orderGoods.setLastArriveSendTime(DateUtils.parseDateTime(child.getLastArriveSendTime()).get());
                    //定向运单失效时间
//                    orderGoods.setDirectionalExpireTime(DateUtils.parseDateTime(child.getDirectionalExpireTime()).get());
//                    orderGoods.setSeniorLogisticsManagerId(child.getSeniorLogisticsManagerId());
//                    orderGoods.setSeniorLogisticsManagerName(child.getSeniorLogisticsManagerName());

                    orderGoods.setOrderNo(orderNo);
                    orderGoods.setOrderGoodsNo(String.valueOf(beginOrderGoodsId));
                    orderGoods.setOrderGoodsStatus(OrderGoodsStatusEnum.Status.CREATED.getCode());
                    orderGoods.setSendAddressId(orderInfo.getSendAddressId());
                    orderGoods.setSendAddressShorter(orderInfo.getSendAddressShorter());
                    //收发货经纬度
                    orderGoods.setSendLongitude(orderInfo.getSendLongitude());
                    orderGoods.setSendLatitude(orderInfo.getSendLatitude());
                    orderGoods.setReceiveLatitude(orderInfo.getReveiveLatitude());
                    orderGoods.setReceiveLongitude(orderInfo.getReveiveLongitude());
                    orderGoods.setReceiveAddressId(orderInfo.getReveiveAddressId());
                    orderGoods.setGoodsName(orderInfo.getGoodsName());
                    orderGoods.setCreateTime(now);
                    orderGoods.setModifiedTime(now);
                    orderGoods.setUserName("loginUserInfo.getUserName()");
                    orderGoods.setUserNo(123L);
                    beginOrderGoodsId = beginOrderGoodsId + 1;
                    orderGoodsMapper.insert(orderGoods);
                }
            } else {
                List<OrderGoodsChildParams> childParamsList = orderGoodsParams.getOrderGoodsChildParams();
                BigDecimal childSum = childParamsList.stream().map(OrderGoodsChildParams::getExtractWeight).reduce(
                        BigDecimal.ZERO, BigDecimal::add);
                if (orderInfo.getResidueWeight().compareTo(childSum) < 0) {
                    throw new RuntimeException("当前货单总吨数已超订单总吨数");
                }
                if (childParamsList.size() > 1) {
                    throw new RuntimeException("全部自有车辆只能全部提取");
                }
                long beginOrderGoodsId = orderGoodsIdGenerate.getOrderGoodsId("pt", childParamsList.size());
                for (OrderGoodsChildParams child : childParamsList) {

                    OrderGoods orderGoods = new OrderGoods();
                    //提取吨数
                    orderGoods.setExtractWeight(child.getExtractWeight());
                    orderGoods.setResidueTransportWeight(child.getExtractWeight());
                    //提取方式 1提取全部 2提取部分
                    Integer extractWay = child.getExtractWay();
                    if (extractWay.equals(2)) {
                        throw new RuntimeException("全部自有车辆只能全部提取");
                    }
                    orderGoods.setExtractWay(extractWay);
                    //需要车辆
                    orderGoods.setNeedTruckNum(child.getNeedTruckNum());
                    //挂单方式
                    orderGoods.setPendingOrderWay(child.getPendingOrderWay());
                    //挂单时间
                    LocalDateTime postedTime = DateUtils.parseDateTime(child.getPendingOrderTime()).get();

                    if (sendLazyTime == null) {
                        sendLazyTime = postedTime;
                    } else if (sendLazyTime.isAfter(postedTime)) {
                        sendLazyTime = postedTime;
                    }
                    orderGoods.setPendingOrderTime(postedTime);
                    orderGoods.setPendingOrderFreight(child.getPendingOrderFreight());

                    orderGoods.setLastArriveSendTime(DateUtils.parseDateTime(child.getLastArriveSendTime()).get());
                    //定向运单失效时间
//                    orderGoods.setDirectionalExpireTime(DateUtils.parseDateTime(child.getDirectionalExpireTime()).get());
//                    orderGoods.setSeniorLogisticsManagerId(child.getSeniorLogisticsManagerId());
//                    orderGoods.setSeniorLogisticsManagerName(child.getSeniorLogisticsManagerName());

                    orderGoods.setOrderNo(orderNo);
                    orderGoods.setOrderGoodsNo(String.valueOf(beginOrderGoodsId));
                    orderGoods.setOrderGoodsStatus(OrderGoodsStatusEnum.Status.CREATED.getCode());
                    orderGoods.setSendAddressId(orderInfo.getSendAddressId());
                    orderGoods.setSendAddressShorter(orderInfo.getSendAddressShorter());
                    //收发货经纬度
                    orderGoods.setSendLongitude(orderInfo.getSendLongitude());
                    orderGoods.setSendLatitude(orderInfo.getSendLatitude());
                    orderGoods.setReceiveLatitude(orderInfo.getReveiveLatitude());
                    orderGoods.setReceiveLongitude(orderInfo.getReveiveLongitude());
                    orderGoods.setReceiveAddressId(orderInfo.getReveiveAddressId());
                    orderGoods.setGoodsName(orderInfo.getGoodsName());
                    orderGoods.setCreateTime(now);
                    orderGoods.setModifiedTime(now);
                    orderGoods.setUserName("loginUserInfo.getUserName()");
                    orderGoods.setUserNo(123L);
                    beginOrderGoodsId = beginOrderGoodsId + 1;
                    orderGoodsMapper.insert(orderGoods);
                }
            }
        } catch (Exception e) {
            throw new RuntimeException(e);
        } finally {
            try {
                if (rLock != null && rLock.isLocked()) {
                    rLock.unlock();
                }
                log.info("锁释放完成");
            } catch (Exception e) {
                log.error("redis 分布式锁释放异常!", e);
            }
        }

        rabbitTemplate.send(RabbitKeyConstants.ORDER_POSTED_EXCHANGE, RabbitKeyConstants.ORDER_POSTED_ROUTE_KEY, MessageBuilder.withBody(orderNo.toString().getBytes()).build());
        Message message = MessageBuilder.withBody(orderNo.toString().getBytes()).build();
        long epochMilli = sendLazyTime.minusMinutes(now.getMinute()).getMinute() * 60 * 1000;
        message.getMessageProperties().setExpiration(String.valueOf(epochMilli));
        rabbitTemplate.send(
                RabbitKeyConstants.ORDER_ON_EXCHANGE, RabbitKeyConstants.ORDER_ON_ROUTE_KEY, message
        );

        return Result.ok();
    }

    @ApiOperation(value = "创建货单-查看订单列表", notes = "<br>By:胡宇帆")
    @PostMapping("/pageCarrierOrderList")
    @UnitCovert(param = false)
    public Result<PageData<FeignPageOrderVO>> pageCarrierOrderList(@RequestBody @Validated PageCarrierOrderListParam param) {
        Result<PageData<FeignPageOrderVO>> dataResult = orderFeign.pageCarrierOrderList(JSONUtil.parse(param).toString());
        return dataResult;
    }

    @ApiOperation(value = "查看货单详情", notes = "<br>By:胡宇帆")
    @GetMapping("/getOrderGoodsInfo")
    @UnitCovert(param = false)
    public Result<OrderGoodsVO> getOrderGoodsInfo(@RequestParam String orderGoodsNo) {
        return Result.ok(orderGoodsService.getOrderGoodsInfoByOrderGoodsNoForPC(orderGoodsNo));
    }

    @ApiOperation(value = "查看货单列表", notes = "<br>By:胡宇帆")
    @PostMapping("/pageOrderGoodsList")
    @UnitCovert(param = false)
    public Result<PageData<OrderGoodsVO>> pageOrderGoodsList(@RequestBody PageOrderGoodsListParam param) {
        IPage<OrderGoodsVO> page = orderGoodsService.pageOrderGoodsList(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }
}
