package com.clx.performance.controller.feign;

import com.clx.performance.service.OrderGoodsDriverTruckService;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import lombok.AllArgsConstructor;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.constraints.NotNull;
import java.util.List;

@RestController
@RequestMapping("/feign/orderGoodsDriverTruck")
@Validated
@Api(tags = "定向车辆Feign")
@AllArgsConstructor
public class TruckFeignController {

    private final OrderGoodsDriverTruckService truckService;

    @GetMapping({"/getTrucksByOrderGoodsNo"})
    Result<List<Integer>> getTrucksByOrderGoodsNo(@RequestParam("orderGoodsNo") @NotNull(message = "货单编号不可为空") String orderGoodsNo){
        return Result.ok(truckService.getTrucksByOrderGoodsNo(orderGoodsNo));
    }

}
