package com.clx.performance.controller.app;

import com.clx.performance.mapper.OrderGoodsMapper;
import com.clx.performance.service.OrderGoodsService;
import com.clx.performance.vo.pc.OrderGoodsVO;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * @ClassName GoodsOrderController
 * @Description
 * @Author kavin
 * @Date 2023/9/17 17:16
 * @Version 1.0
 */

@Slf4j
@RestController
@RequestMapping("/app/goodsOrder")
@Validated
@Api(tags = "APP-货单")
public class AppGoodsOrderController {

    @Autowired
    OrderGoodsService orderGoodsService;

    @Autowired
    OrderGoodsMapper orderGoodsMapper;


    @ApiOperation(value = "查看货单详情", notes = "<br>By:胡宇帆")
    @GetMapping("/getOrderGoodsInfo")
    @UnitCovert(param = false)
    public Result<OrderGoodsVO> getOrderGoodsInfo(@RequestParam String orderGoodsNo) {
        return Result.ok(orderGoodsService.getOrderGoodsInfoByOrderGoodsNoForAPP(orderGoodsNo));
    }

}
