package com.clx.performance.vo.pc;

import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.convertor.field.Convert;
import com.msl.common.convertor.field.Converted;
import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.math.BigDecimal;

/**
* @Author: aiqinguo
* @Description: 运单表
* @Date: 2023/09/18 11:34:50
* @Version: 1.0
*/

@Getter
@Setter
@NoArgsConstructor
public class OrderGoodsVO {

    @ApiModelProperty("订单编号")
    private String orderNo;

    @ApiModelProperty("货单编号")
    private String orderGoodsNo;

    @ApiModelProperty("货单状态")
    private Integer orderGoodsStatus;

    @ApiModelProperty("提取吨数")
    private BigDecimal extractWeight;

    @ApiModelProperty("剩余拉运吨数")
    private BigDecimal residueTransportWeight;

    @ApiModelProperty("已拉运吨数")
    private BigDecimal alreadyTransportWeight;

    @ApiModelProperty("发货地址ID")
    private Integer sendAddressId;

    @ApiModelProperty(value = "发货地址全称")
    private String sendAddressAll;

    @ApiModelProperty("发货地址简称")
    private String sendAddressShorter;

    @ApiModelProperty("发货地址经度")
    private BigDecimal sendLongitude;

    @ApiModelProperty("发货地址纬度")
    private BigDecimal sendLatitude;

    @ApiModelProperty("收货地址ID")
    private Integer receiveAddressId;

    @ApiModelProperty(value="收货地址全称")
    private String reveiveAddressAll;

    @ApiModelProperty("收货地址简称")
    private String receiveAddressShorter;

    @ApiModelProperty("收货地址经度")
    private BigDecimal receiveLongitude;

    @ApiModelProperty("收货地址纬度")
    private BigDecimal receiveLatitude;

    @ApiModelProperty("货物ID")
    private Integer goodsId;

    @ApiModelProperty("货物名称")
    private String goodsName;

    @ApiModelProperty("挂单方式  1公开派单  2定向派单")
    private Integer pendingOrderWay;

    @ApiModelProperty("定向运单失效时间")
    private String directionalExpireTime;

    @ApiModelProperty("最晚到达货源地时间/运单的最晚装货时间")
    private String lastArriveSendTime;

    @ApiModelProperty("挂单时间")
    private String pendingOrderTime;

    @ApiModelProperty("提取方式 1提取全部 2提取部分")
    private Integer extractWay;

    @ApiModelProperty("需要车辆/辆")
    private Integer needTruckNum;

    @ApiModelProperty("高级物流经理id")
    private Integer seniorLogisticsManagerId;

    @ApiModelProperty("高级物流经理姓名")
    private String seniorLogisticsManagerName;

    @ApiModelProperty("挂单运费")
    @MoneyOutConvert
    private BigDecimal pendingOrderFreight;

    @ApiModelProperty("创建人用户编号")
    private Long userNo;

    @ApiModelProperty("创建人姓名")
    private String userName;

    @ApiModelProperty("创建时间")
    private String createTime;


}