package com.clx.performance.enums;

import com.msl.common.enums.ResultEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;


@Getter
@AllArgsConstructor
public enum PerformanceResultEnum implements ResultEnum {



    /**
     * 系统
     */
    SIGN_NULL(1001, "签名不存在"),
    SIGN_ERROR(1002, "签名错误"),
    TIMESTAMP_ERROR(1003, "请求不在时间范围内"),
    INCREMENT_ERROR(1004, "编码生成失败"),
    HTTP_ERROR(1005, "HTTP请求失败"),
    LOCK_ERROR(1006,"加锁失败"),
    TRY_LOCK_ERROR(1007,"操作频繁,请稍后重试"),
    FEIGN_ERROR(1008, "服务调用失败"),
    /**
     * 通用
     */
    USER_NULL(1101, "用户不存在"),
    MOBILE_NULL(1102, "手机号码未注册"),
    USER_NOT_REGISTER(1103, "用户尚未注册"),
    USER_NOT_AUTH(1104, "用户暂未实名"),
    DATA_NOT_FIND(1105, "数据不存在"),
    DATA_REPEAT(1106, "数据重复"),


    ORDER_NO_FOUND(1200, "货单不存在"),
    ORDER_WEIGHT_LACK(1200, "剩余数量不足"),
    ORDER_INVALID(1200, "无效的货单"),


    ORDER_CHILD_NO_FOUND(1301, "运单不存在"),
    ORDER_CHILD_STATUS_CHANGED(1302, "运单状态已变更，请重新刷新页面"),
    ORDER_CHILD_CANCELED(1303, "运单状态已取消"),
    ORDER_CHILD_COMPLETE(1304, "运单状态已完成"),
    ORDER_CHILD_LOAD_TIMEOUT(1305, "超过装货截止时间"),
    ORDER_CHILD_CANCEL_FORBID(1306, "运单无法取消"),
    ORDER_CHILD_CANCEL_FORBID_COUNT(1307, "超出最大取消数量"),
    ORDER_CHILD_POUND_AUDIT(1307, "磅单审核中"),


    ;
    private final int code;
    private final String msg;
}
