package com.clx.performance.struct;

import com.clx.performance.enums.PlatformAccountConfigEnum;
import com.clx.performance.model.PlatformAccountConfig;
import com.clx.performance.vo.pc.carrier.settle.*;
import com.msl.common.utils.DateStructUtil;
import com.msl.common.utils.DateUtils;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;

import java.util.List;
import java.util.Objects;

@Mapper(componentModel = "spring", uses = DateStructUtil.class, imports = {PlatformAccountConfigEnum.class, Objects.class, DateUtils.class})
public interface PlatformAccountConfigStruct {
    @Mapping(target = "businessTypeMsg", expression = "java(Objects.isNull(config.getBusinessType()) ? null : PlatformAccountConfigEnum.BusinessType.getMsgByCode(config.getBusinessType()))")
    @Mapping(target = "ownerTypeMsg", expression = "java(Objects.isNull(config.getOwnerType()) ? null : PlatformAccountConfigEnum.OwnerType.getMsgByCode(config.getOwnerType()))")
    @Mapping(target = "invoiceTypeMsg", expression = "java(Objects.isNull(config.getInvoiceType()) ? null : PlatformAccountConfigEnum.InvoiceType.getMsgByCode(config.getInvoiceType()))")
    @Mapping(target = "configRangeMsg", expression = "java(Objects.isNull(config.getConfigRange()) ? null : PlatformAccountConfigEnum.ConfigRange.getMsgByCode(config.getConfigRange()))")
    CarrierPagePlatformAccountConfigVO convertToDetail(PlatformAccountConfig config);

    List<CarrierPagePlatformAccountConfigVO> convertToVOList(List<PlatformAccountConfig> settlementOwners);

}
