package com.clx.performance.service.impl.settle;

import com.clx.performance.param.pc.owner.PageCarrierSettlementPlatformServiceFeeParam;
import com.clx.performance.service.settle.SettlementPlatformServiceFeeExportService;
import com.clx.performance.service.settle.SettlementPlatformServiceFeeService;
import com.clx.performance.utils.excel.ExcelData;
import com.clx.performance.utils.excel.ExcelField;
import com.clx.performance.utils.excel.ExcelSheet;
import com.clx.performance.utils.excel.ExcelUtil;
import com.clx.performance.vo.pc.carrier.settle.SettlementPlatformServiceFeeVO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;

@Slf4j
@Service
public class SettlementPlatformServiceFeeExportServiceImpl implements SettlementPlatformServiceFeeExportService {

    @Autowired
    private SettlementPlatformServiceFeeService settlementPlatformServiceFeeService;

    @Override
    public void exportPlatformServiceFee(PageCarrierSettlementPlatformServiceFeeParam param) {
        param.setPage(1);
        param.setPageSize(1000000);
        List<SettlementPlatformServiceFeeVO> list = settlementPlatformServiceFeeService.pagePlatformServiceFee(param).getRecords();


        // 组装表头
        List<ExcelField> fieldList = new ArrayList<>();
        fieldList.add(new ExcelField(0, "序号", "index", 2000));
        fieldList.add(new ExcelField(1, "运单编号", "childNo", 5000));
        fieldList.add(new ExcelField(2, "司机姓名", "driverName", 5000));
        fieldList.add(new ExcelField(3, "手机号", "driverMobile", 5000));
        fieldList.add(new ExcelField(4, "发货地址", "sendAddress", 5000));
        fieldList.add(new ExcelField(5, "收货地址", "receiveAddress", 5000));
        fieldList.add(new ExcelField(6, "车牌号", "truckNo", 10000));
        
        fieldList.add(new ExcelField(7, "结算金额", "settlementFreight", 10000));
        fieldList.add(new ExcelField(8, "平台服务费率", "invoiceServiceFeeRate", 10000));
        fieldList.add(new ExcelField(9, "平台服务费", "invoiceServiceFee", 10000));

        fieldList.add(new ExcelField(10, "创建时间", "createTime", 5000));

        // 组装数据
        List<List<ExcelData>> dataList = new ArrayList<>();
        for (int i=0; i<list.size(); i++){

            SettlementPlatformServiceFeeVO dto = list.get(i);
            List<ExcelData> rowData = new ArrayList<>();

            rowData.add(new ExcelData(i+1));
            rowData.add(new ExcelData(dto.getChildNo()));
            rowData.add(new ExcelData(dto.getDriverName()));
            rowData.add(new ExcelData(dto.getDriverMobile()));
            rowData.add(new ExcelData(dto.getSendAddress()));
            rowData.add(new ExcelData(dto.getReceiveAddress()));
            rowData.add(new ExcelData(dto.getTruckNo()));

            rowData.add(new ExcelData(dto.getSettlementFreight().movePointLeft(2).setScale(2, RoundingMode.HALF_UP).toString()));
            rowData.add(new ExcelData(dto.getInvoiceServiceFeeRate().toString()+"%"));
            rowData.add(new ExcelData(dto.getInvoiceServiceFee().movePointLeft(2).setScale(2, RoundingMode.HALF_UP).toString()));

            rowData.add(new ExcelData(dto.getCreateTime()));

            dataList.add(rowData);
        }

        // 导出
        ExcelUtil.export(new ExcelSheet("平台服务费统计", fieldList, dataList));
    }

}
