package com.clx.performance.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * @author kavin
 * Date 2023-11-22
 * Time 10:54
 */
@Accessors(chain = true)
@TableName("large_screen_address_route")
@Data
@Builder
public class LargeScreenAddressRoute implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @TableField("receive_name")
    @ApiModelProperty("收货地址")
    private String receiveName;

    @TableField("send_name")
    @ApiModelProperty("发货地址")
    private String sendName;

    @TableField("receive_system_address_id")
    @ApiModelProperty("收货标准地址id")
    private Integer receiveSystemAddressId;

    @TableField("send_system_address_id")
    @ApiModelProperty("发货标准地址id")
    private Integer sendSystemAddressId;

    @Override
    @KeyColumn("id")
    public Integer gainKey() {
    return this.id;
    }
}
