package com.clx.performance.job;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONUtil;
import com.clx.performance.param.pc.driver.NetworkDriverAccountParam;
import com.clx.performance.service.OrderChildService;
import com.clx.performance.service.settle.NetworkDriverAccountService;
import com.clx.user.feign.DriverFeign;
import com.clx.user.vo.pc.driver.user.DriverInfoVo;
import com.msl.common.result.Result;
import com.xxl.job.core.handler.annotation.XxlJob;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.List;

@Slf4j
@Component
@AllArgsConstructor
public class NetworkDriverAccountSyncJob {


    private final DriverFeign driverFeign;

    private final NetworkDriverAccountService networkDriverAccountService;



    /**
     * 网络货运同步司机账户信息
     */
    @XxlJob("networkDriverAccountSync")
    public void networkDriverAccountSync() {
        Result<List<DriverInfoVo>> result = driverFeign.getDriverInfoList();
        List<DriverInfoVo> data = result.getData();
        log.info("查询出所有司机信息:{}", JSONUtil.parse(data));
        for (DriverInfoVo vo : data) {
            if (ObjectUtil.isNull(vo.getUserNo())) {
                continue;
            }
            NetworkDriverAccountParam param = new NetworkDriverAccountParam();
            param.setDriverUserName(vo.getName());
            param.setDriverUserNo(vo.getUserNo());
            param.setMobile(vo.getMobile());
            try {
                Thread.sleep(2000L);
            } catch (Exception e) {
                throw new RuntimeException(e);
            }
            networkDriverAccountService.createNetworkDriverAccount(param);

        }

    }
}
