package com.clx.performance.controller.pc.linewarn;

import com.clx.performance.service.linewarn.LineWarnTraceService;
import com.clx.performance.vo.pc.linewarn.LineWarnTraceVO;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.constraints.NotNull;

@Slf4j
@RestController
@Validated
@Api(tags = "线路预警-轨迹信息")
@RequestMapping(value="/pc/lineWarnInfo")
public class LineWarnTraceController {

    @Autowired
    private LineWarnTraceService lineWarnTraceService;

    @ApiOperation(value = "获取轨迹信息",notes = "<br>By:艾庆国")
    @GetMapping("/getTraceInfo")
    public Result<LineWarnTraceVO> getTraceInfo(@NotNull(message = "货单编号不能为空") @Validated String orderGoodsNo) {
        return Result.ok(lineWarnTraceService.getTraceInfo(orderGoodsNo));
    }

}
