package com.clx.performance.param.pc.payment;

import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;

@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
@Builder
@Accessors(chain = true)
public class PayPlatformFeeParam {
	@ApiModelProperty(value = "支付来源", example = "2234", dataType = "int")
	Integer from;
	@ApiModelProperty(value = "支付方密码", example = "2356", dataType = "String")
	String pwd;

	@ApiModelProperty(value = "金额", example = "2356", dataType = "int")
	Integer figure;
	@NotBlank(message = "交易单号不能为空")
	@ApiModelProperty(value = "交易单号", example = "2356", dataType = "String")
	String tradeNo;
}
