package com.clx.performance.param.pc.loan.carrier;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import javax.validation.constraints.Max;
import javax.validation.constraints.NotNull;

/**
 * @Author: aiqingguo
 * @Date: 2023-10-11 17:30:57
 * @Version: 1.0
 */
@Setter
@Getter
@ToString
@NoArgsConstructor
public class BorrowerConfigAddParam {

    @ApiModelProperty(value = "借出方id", example = "1")
    @NotNull(message = "借出方id不能为空")
    private Integer borrowerId;
    @ApiModelProperty(value = "类型：1虚拟货币 2 资金", example = "1")
    @NotNull(message = "类型不能为空")
    private Integer type;
    @ApiModelProperty(value = "借款天数", example = "1")
    @NotNull(message = "借款天数不能为空")
    @Max(value = 365, message = "借款天数需小于等于365")
    private Integer day;

}
