package com.clx.performance.param.feign.transport;

import io.swagger.annotations.ApiModelProperty;
import lombok.*;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.List;

@Data
public class ThirdOrderChildBrokerParam {

    @ApiModelProperty(value = "运单编码", dataType="String", required = true)
    @NotBlank(message = "订单编码不能为空")
    private String childNo;

    @ApiModelProperty(value = "订单编码", dataType="String", required = true)
    @NotBlank(message = "货单编码不能为空")
    private String orderNo;
    @ApiModelProperty(value = "车牌号", dataType="String", required = true)
    @NotBlank(message = "车牌号不能为空")
    private String truckNo;

    @ApiModelProperty(value = "运费单价 单位分 (司机运费单价)", dataType="Integer", required = true)
    @NotNull(message = "运费单价不能为空")
    private Integer freightPrice;
    @ApiModelProperty(value = "运费 单位分 (含税金额)", dataType="Integer", required = true)
    @NotNull(message = "运费不能为空")
    private Integer freight;
    @ApiModelProperty(value = "实付运费 单位分 (司机运费总价)", dataType="Integer", required = true)
    @NotNull(message = "实付运费不能为空")
    private Integer freightNoCard;
    @ApiModelProperty(value = "溢价金额", dataType = "Integer", required = true)
    @NotNull(message = "溢价金额不能为空")
    private Integer orderChildBrokerBeyondFreight = 0;
    @ApiModelProperty(value = "司机实际净重", dataType="BigDecimal", required = true)
    @NotNull(message = "司机实际净重不能为空")
    private BigDecimal net;
    @ApiModelProperty(value = "装车净重", dataType="BigDecimal")
    @NotNull(message = "装车净重不能为空")
    private BigDecimal loadNet;

    @ApiModelProperty(value = "发货地址", dataType="String", required = true)
    @NotBlank(message = "发货地址不能为空")
    private String sendAddress;
    @ApiModelProperty(value = "货源所在省份", dataType="String", required = true)
    @NotBlank(message = "货源所在省份不能为空")
    private String sendProvince;
    @ApiModelProperty(value = "货源所在城市", dataType="String", required = true)
    @NotBlank(message = "货源所在城市不能为空")
    private String sendCity;
    @ApiModelProperty(value = "货源所在区县", dataType="String", required = true)
    @NotBlank(message = "货源所在区县不能为空")
    private String sendCounty;
    @ApiModelProperty(value = "货源所在乡镇", dataType="String", required = true)
//    @NotBlank(message = "货源所在乡镇不能为空")
    private String sendTown;
    @ApiModelProperty(value = "发货人", dataType="String", required = true)
    @NotBlank(message = "发货人不能为空")
    private String sendName;
    @ApiModelProperty(value = "发货人手机号", dataType="String", required = true)
    @NotBlank(message = "发货人手机号不能为空")
    private String sendMobile;

    @ApiModelProperty(value = "收货人所在省", dataType="String", required = true)
    @NotBlank(message = "收货人所在省不能为空")
    private String receiveProvince;
    @ApiModelProperty(value = "收货人所在城市", dataType="String", required = true)
    @NotBlank(message = "收货人所在城市不能为空")
    private String receiveCity;
    @ApiModelProperty(value = "收货人所在区县", dataType="String", required = true)
    @NotBlank(message = "收货人所在区县不能为空")
    private String receiveCounty;
    @ApiModelProperty(value = "收货人所在乡镇", dataType="String", required = true)
//    @NotBlank(message = "收货人所在乡镇不能为空")
    private String receiveTown = "手动";
    @ApiModelProperty(value = "收货地址", dataType="String", required = true)
    @NotBlank(message = "收货地址不能为空")
    private String receiveAddress;
    @ApiModelProperty(value = "收货人", dataType="String", required = true)
    @NotBlank(message = "收货人不能为空")
    private String receiveName;
    @ApiModelProperty(value = "收货人手机号", dataType="String", required = true)
    @NotBlank(message = "收货人手机号不能为空")
    private String receiveMobile;

    @ApiModelProperty(value = "装车地址经度", required = true)
    @NotBlank(message = "装车地址经度不能为空")
    private String loadLongitude;
    @ApiModelProperty(value = "装车地址纬度", required = true)
    @NotBlank(message = "装车地址纬度不能为空")
    private String loadLatitude;
    @ApiModelProperty(value = "卸车地址经度", required = true)
    @NotBlank(message = "卸车地址经度不能为空")
    private String unloadLongitude;
    @ApiModelProperty(value = "卸车地址纬度", required = true)
    @NotBlank(message = "卸车地址纬度不能为空")
    private String unloadLatitude;
    @ApiModelProperty(value = "运输距离（公里）", required = true)
    @NotNull(message = "运输距离不能为空")
    private BigDecimal distance;

    @ApiModelProperty(value = "接单时间", dataType="String", required = true)
    @NotBlank(message = "接单时间不能为空")
    private String payTime;
    @ApiModelProperty(value = "装车时间", dataType="String", required = true)
    @NotBlank(message = "装车时间不能为空")
    private String loadTime;
    @ApiModelProperty(value = "卸车时间", dataType="String", required = true)
    @NotBlank(message = "卸车时间不能为空")
    private String unloadTime;
    @ApiModelProperty(value = "支付完成时间", dataType="String", required = true)
    @NotBlank(message = "支付完成时间不能为空")
    private String payFinishedTime;

//    @ApiModelProperty(value = "备注", dataType="String")
//    private String remark;
//    @ApiModelProperty(value = "创建时间", dataType="String", required = true)
//    private String createTime;

    @ApiModelProperty(value = "收货单位", dataType="String")
    private String receiveCompany;
    @ApiModelProperty(value = "发货单位", dataType="String")
    private String sendCompany;
    @ApiModelProperty(value = "卸车净重", dataType="BigDecimal", required = true)
    @NotNull(message = "卸车净重不能为空")
    private BigDecimal receiveNet;

    @ApiModelProperty(value = "货物名称", dataType="String", required = true)
    @NotBlank(message = "货物名称不能为空")
    private String goodsName;
//    @ApiModelProperty(value = "是否车主本人：1是，0否", dataType="Integer", required = true)
//    private Integer personalDriverFlag;

    @ApiModelProperty(value = "垫付类型 0 全额垫付 1 不垫付服务费", dataType="Integer", required = true)
    @NotNull(message = "垫付类型不能为空")
    private Integer advanceType;

    @ApiModelProperty(value = "货物价格 单位 分", required = true)
    @NotNull(message = "货物价格不能为空")
    private Integer goodsPrice;

    @ApiModelProperty(value = "源订单号 (承运平台订单号)")
    @NotBlank(message = "源订单号不能为空")
    private String sourceOrderNo;
    @ApiModelProperty(value = "源货单号 (承运平台货单号)")
    @NotBlank(message = "源货单号不能为空")
    private String sourceGoodsNo;

    @ApiModelProperty(value = "源开票方式 (开票方式) ：1 装车 2 卸车")
    @NotNull(message = "源开票方式不能为空")
    private Integer sourceInvoicingType;
    @ApiModelProperty(value = "源单价 (承运单价)")
    @NotNull(message = "源单价不能为空")
    private BigDecimal sourceFreightPrice;
    @ApiModelProperty(value = "源开票金额 (开票金额)")
    @NotNull(message = "源开票金额不能为空")
    private BigDecimal sourceInvoicingPrice;
    @ApiModelProperty(value = "源亏吨金额 (亏吨金额)")
    @NotNull(message = "源亏吨金额不能为空")
    private BigDecimal sourceLossPrice;

    @ApiModelProperty(value = "装车磅单图片", required = true)
    @NotEmpty(message = "装车磅单图片不能为空")
    private List<String> loadPoundImages;
    @ApiModelProperty(value = "卸车磅单图片", required = true)
    @NotEmpty(message = "卸车磅单图片不能为空")
    private List<String> unLoadPoundImages;

    @ApiModelProperty(value = "关联账号(货主手机号)", required = true)
    @NotBlank(message = "关联账号不能为空")
    private String invoiceRelationNo;

    @ApiModelProperty(value = "货单信息", required = true)
    @Valid
    private ThirdOrderInfoDTO orderInfoDTO;

    @ApiModelProperty(value = "车主信息", required = true)
    @Valid
    private OrderChildDriverInfoDTO truckDriverInfoDTO;

    @ApiModelProperty(value = "司机信息", required = true)
    @Valid
    private OrderChildDriverInfoDTO driverInfoDTO;

    @ApiModelProperty(value = "车主银行卡信息", required = true)
    @Valid
    private OrderChildBankInfoDTO truckDriverBankInfoDTO;

    @ApiModelProperty(value = "司机银行卡信息", required = true)
    @Valid
    private OrderChildBankInfoDTO driverBankInfoDTO;

    @ApiModelProperty(value = "车辆信息", required = true)
    @Valid
    private OrderChildTruckInfoDTO truckInfoDTO;

    @ApiModelProperty(value = "运单轨迹", required = true)
    @Valid
    @NotEmpty(message = "运单轨迹不能为空")
    private List<OrderChildTruckTraceDTO> brokerTraceList;

//    @ApiModelProperty(value = "来源:0-货易来,1-诚联信 2承运", hidden = true)
//    private Integer source;

}
