package com.clx.performance.controller.app;

import com.clx.performance.param.app.OrderChildWeighPictureParam;
import com.clx.performance.service.OrderChildWeighPictureService;
import com.clx.performance.vo.app.PictureVo;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


@Slf4j
@RestController
@RequestMapping(value="/app/driver/orderChildWeighPicture")
@Validated
@Api(tags = "APP-运单电子磅单")
public class AppDriverOrderChildWeighPictureController {

    @Autowired
    private OrderChildWeighPictureService pictureService;



    @ApiOperation(value = "查询电子磅单", notes = "<br>By:李瑞新")
    @PostMapping("/getWeighPictures")
    public Result<PictureVo> getWeighPictures(@RequestBody @Validated OrderChildWeighPictureParam param) {

        return Result.ok(pictureService.getWeighPictures(param));
    }

}
