package com.clx.performance.feign;

import com.clx.performance.component.ThirdComponent;
import com.msl.common.result.Result;
import feign.Request;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Bean;

@Slf4j
public class FeignInterceptor implements RequestInterceptor {



  @Override
  public void apply(RequestTemplate template){
    // 通过template获取到请求体（已经被转成json）
    String jsonBody = template.requestBody().asString();
    log.info("请求参数：{}", jsonBody);
    try {
      //调用网络货运请求需要加密处理
      jsonBody = ThirdComponent.encrypt(jsonBody);
    } catch (Exception e) {
      throw new RuntimeException(e);
    }
    template.body(jsonBody);
  }

  @Bean
  public Request.Options requestOptions() {
    return new Request.Options(30000, 30000);
  }
}