package com.clx.performance.dao.impl.linewarn;

import com.clx.performance.dao.linewarn.LineWarnRangeDao;
import com.clx.performance.enums.linewarn.LineWarnRangEnum;
import com.clx.performance.mapper.linewarn.LineWarnRangeMapper;
import com.clx.performance.model.linewarn.LineWarnRange;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public class LineWarnRangeDaoImpl extends BaseDaoImpl<LineWarnRangeMapper, LineWarnRange, Integer> implements LineWarnRangeDao {


    @Override
    public List<LineWarnRange> ListByWarnConfigId(Integer warnConfigId) {
        return list(lQrWrapper()
                        .eq(LineWarnRange::getWarnConfigId, warnConfigId)
                        .eq(LineWarnRange::getStatus, LineWarnRangEnum.Status.ENABLE.getCode())
                        .orderByDesc(LineWarnRange::getId)
                );
    }

    @Override
    public boolean updateDisable(LineWarnRange item) {
        return update(lUdWrapper()
                .eq(LineWarnRange::getWarnConfigId, item.getWarnConfigId())
                .eq(StringUtils.isNotBlank(item.getOrderGoodsNo()), LineWarnRange::getOrderGoodsNo, item.getOrderGoodsNo())
                .set(LineWarnRange::getStatus, LineWarnRangEnum.Status.DISABLE.getCode())
        );
    }
}
