package com.clx.performance.enums.vehiclewarn;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;

public enum VehicleWarnUserEnum {
    ;

    @Getter
    @AllArgsConstructor
    public enum DeleteStatus {
        NO(0, "否"),
        YES(1, "是"),

        ;

        private final Integer code;
        private final String msg;

    }
    @Getter
    @AllArgsConstructor
    public enum NoticeStatus {
        NO(0, "禁用"),
        YES(1, "开启"),

        ;

        private final Integer code;
        private final String msg;
        public static Optional<NoticeStatus> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }
        public static String getMsgByCode(int code) {
            return getByCode(code).map(NoticeStatus::getMsg).orElse(null);
        }
    }

}
