package com.clx.performance;

import com.clx.order.feign.OrderFeign;
import com.clx.order.vo.feign.OrderOwnTruckVo;
import com.clx.performance.component.GoodsOrderTruckRecordComponent;
import com.clx.performance.component.OrderGoodsStatusLazyComponent;
import com.clx.performance.dao.OrderGoodsDao;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.test.context.junit4.SpringRunner;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

@SpringBootTest
@RunWith(SpringRunner.class)
public class JobTest {

    @Autowired
    private OrderFeign orderFeign;

    @Autowired
    private RabbitTemplate rabbitTemplate;

    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    @Autowired
    private OrderGoodsStatusLazyComponent orderGoodsStatusLazyComponent;

    @Autowired
    private OrderGoodsDao orderGoodsDao;

    @Autowired
    private GoodsOrderTruckRecordComponent recordComponent;

    @Test
    public void test1() {
        List<String> list = new ArrayList<>();
        list.add("晋A99999");

        recordComponent.saveTruckRecord("123", list);
        recordComponent.getPrivateTruckList("123", 1001183036834771013L);
        System.out.println();
    }
}
