package com.clx.performance.sqlProvider.breakcontract;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.param.pc.breakcontract.carrier.PageBreakContractOwnerRuleParam;
import com.clx.performance.vo.pc.breakcontract.carrier.BreakContractOwnerRuleVO;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.jdbc.SQL;

public class BreakContractOwnerRuleSqlProvider {

    public String pageByParam(@Param("page") Page<BreakContractOwnerRuleVO> page, @Param("param") PageBreakContractOwnerRuleParam param) {
        return new SQL(){{

            SELECT(" id, name, file, rule_json as ruleJson, " +
                    " status, " +
                    " date_format(create_time, '%Y-%m-%d %H:%i:%s') as createTime, " +
                    " date_format(modified_time, '%Y-%m-%d %H:%i:%s') as modifiedTime "
            );

            FROM("break_contract_owner_rule");

            if (StringUtils.isNotBlank(param.getName())) {WHERE("name = #{param.name}");}
            if (param.getStatus() != null) {WHERE("status = #{param.status}");}

            if (StringUtils.isNotBlank(param.getBeginTime())) {WHERE("create_time >= #{param.beginTime}");}
            if (StringUtils.isNotBlank(param.getEndTime())) {WHERE("create_time <= #{param.endTime}");}

            ORDER_BY("create_time desc");
        }}.toString();
    }

}
