package com.clx.performance.service.impl.breakcontract;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.breakcontract.BreakContractSettlementDriverDetailDao;
import com.clx.performance.model.breakcontract.BreakContractSettlementDriverDetail;
import com.clx.performance.param.pc.breakcontract.carrier.PageCarrierBreakContractSettlementDriverDetailParam;
import com.clx.performance.service.breakcontract.BreakContractSettlementDriverDetailService;
import com.clx.performance.struct.breakcontract.BreakContractSettlementDriverDetailStruct;
import com.clx.performance.utils.excel.ExcelData;
import com.clx.performance.utils.excel.ExcelField;
import com.clx.performance.utils.excel.ExcelSheet;
import com.clx.performance.utils.excel.ExcelUtil;
import com.clx.performance.vo.pc.breakcontract.carrier.PageCarrierBreakContractSettlementDriverDetailVO;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;


/**
 * @author liruixin
 * Date 2023-10-24
 * Time 16:02
 */
@Service
@Slf4j
@AllArgsConstructor
public class BreakContractSettlementDriverDetailServiceImpl  implements BreakContractSettlementDriverDetailService {

    private final BreakContractSettlementDriverDetailDao breakContractSettlementDriverDetailDao;
    private final BreakContractSettlementDriverDetailStruct breakContractSettlementDriverDetailStruct;


    @Override
    public IPage<PageCarrierBreakContractSettlementDriverDetailVO> pageCarrierBreakContractSettlementDriverDetailList(PageCarrierBreakContractSettlementDriverDetailParam param) {
        IPage<BreakContractSettlementDriverDetail> breakContractSettlementDriverDetail = breakContractSettlementDriverDetailDao.pageCarrierBreakContractSettlementDriverDetailList(param);
        List<PageCarrierBreakContractSettlementDriverDetailVO> list = breakContractSettlementDriverDetailStruct.covertToCarrierList(breakContractSettlementDriverDetail.getRecords());
        return new Page<PageCarrierBreakContractSettlementDriverDetailVO>().setRecords(list).setTotal(breakContractSettlementDriverDetail.getTotal()).setPages(breakContractSettlementDriverDetail.getPages());
    }

    @Override
    public SXSSFWorkbook exportCarrierBreakContractSettlementDriverDetailList(PageCarrierBreakContractSettlementDriverDetailParam param) {
        param.setPage(1);
        param.setPageSize(1000000);
        IPage<PageCarrierBreakContractSettlementDriverDetailVO> settlementOwnerDetail = pageCarrierBreakContractSettlementDriverDetailList(param);

        List<PageCarrierBreakContractSettlementDriverDetailVO> list = settlementOwnerDetail.getRecords();

        // 组装表头
        List<ExcelField> fieldList = new ArrayList<>();
        fieldList.add(new ExcelField(0, "序号", "index", 2000));
        fieldList.add(new ExcelField(1, "违约单号", "breakNo", 5000));
        fieldList.add(new ExcelField(2, "车主编码", "truckOwnUserNo", 5000));
        fieldList.add(new ExcelField(3, "运单编号", "childNo", 5000));

        fieldList.add(new ExcelField(4, "司机名称", "driverName", 5000));
        fieldList.add(new ExcelField(5, "违约方", "breachContractPartyType", 5000));
        fieldList.add(new ExcelField(6, "违约金额", "figure", 5000));
        fieldList.add(new ExcelField(7, "创建人", "createName", 5000));
        fieldList.add(new ExcelField(8, "创建时间", "createTime", 5000));
        fieldList.add(new ExcelField(9, "结算单号", "settlementNo", 5000));

        // 组装数据
        List<List<ExcelData>> dataList = new ArrayList<>();
        for (int i=0; i<list.size(); i++){

            PageCarrierBreakContractSettlementDriverDetailVO dto = list.get(i);
            List<ExcelData> rowData = new ArrayList<>();

            rowData.add(new ExcelData(i+1));
            rowData.add(new ExcelData(dto.getBreakNo()));
            rowData.add(new ExcelData(dto.getTruckOwnUserNo()+""));
            rowData.add(new ExcelData(dto.getChildNo()));

            rowData.add(new ExcelData(dto.getDriverName()));
            rowData.add(new ExcelData(dto.getBreakContractPartyTypeMsg()));
            rowData.add(new ExcelData(dto.getFigure().movePointLeft(2)));
            rowData.add(new ExcelData(dto.getCreateName()));
            rowData.add(new ExcelData(dto.getCreateTime()));
            rowData.add(new ExcelData(dto.getSettlementNo()));

            dataList.add(rowData);
        }

        ExcelSheet excelSheet = new ExcelSheet("车主违约计费", "车主违约计费", fieldList, dataList);

        //创建excel
        return ExcelUtil.create(excelSheet);
    }
}
