package com.clx.performance.service.impl.breakcontract;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.dao.OrderChildDao;
import com.clx.performance.dao.breakcontract.BreakContractDriverRecordDao;
import com.clx.performance.enums.BreakContractRecordEnum;
import com.clx.performance.enums.PerformanceResultEnum;
import com.clx.performance.model.OrderChild;
import com.clx.performance.model.breakcontract.BreakContractDriverRecord;
import com.clx.performance.param.app.breakcontract.DriverPageBreakContractDriverRecordParam;
import com.clx.performance.param.pc.breakcontract.carrier.BreakContractDriverRecordAddParam;
import com.clx.performance.param.pc.breakcontract.carrier.PageBreakContractDriverRecordParam;
import com.clx.performance.service.breakcontract.BreakContractDriverRecordService;
import com.clx.performance.service.impl.UniqueOrderNumService;
import com.clx.performance.vo.app.breakcontract.DriverBreakContractDriverRecordVO;
import com.clx.performance.vo.pc.breakcontract.carrier.BreakContractDriverRecordVO;
import com.msl.common.utils.LocalDateTimeUtils;
import com.msl.user.data.UserSessionData;
import com.msl.user.utils.TokenUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Objects;

/**
 * @author liruixin
 * Date 2023-10-24
 * Time 16:02
 */
@Slf4j
@Service
public class BreakContractDriverRecordServiceImpl  implements BreakContractDriverRecordService {

    @Autowired
    private BreakContractDriverRecordDao breakContractDriverRecordDao;
    @Autowired
    private OrderChildDao orderChildDao;
    @Autowired
    private UniqueOrderNumService uniqueOrderNumService;

    @Override
    public void saveRecord(BreakContractDriverRecordAddParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        Long userNo = loginUserInfo.getUserNo();

        String breakNo = childNoGenerate();
        OrderChild orderChild = orderChildDao.getByChildNo(param.getChildNo()).orElseThrow(PerformanceResultEnum.ORDER_CHILD_NO_FOUND);

        LocalDateTime time = LocalDateTime.now();

        BreakContractDriverRecord record = new BreakContractDriverRecord();
        record.setBreakNo(breakNo);
        record.setTriggerType(BreakContractRecordEnum.TriggerType.MANUAL.getCode());
        if (Objects.equals(param.getBreachContractPartyType(), BreakContractRecordEnum.BreachContractPartyType.DRIVER.getCode())) {
            record.setBreachContractPartyType(BreakContractRecordEnum.BreachContractPartyType.DRIVER.getCode());
            if (param.getTimeLimit() != null) {
                record.setTimeLimit(param.getTimeLimit());
                record.setLimitTime(time.plusSeconds(param.getTimeLimit().multiply(BigDecimal.valueOf(3600L)).intValue()));
            }
        }
        else {
            record.setBreachContractPartyType(BreakContractRecordEnum.BreachContractPartyType.PLATFORM.getCode());
        }
        record.setChildNo(param.getChildNo());
        record.setFigure(param.getFigure());

        record.setRemark(param.getRemark());
        record.setTruckNo(orderChild.getTruckNo());
        record.setTruckOwnUserNo(orderChild.getTruckOwnUserNo());
        record.setTruckOwnName(orderChild.getTruckOwnName());
        record.setDriverUserNo(orderChild.getDriverUserNo());
        record.setDriverName(orderChild.getDriverName());

        record.setCreateBy(userNo);
        record.setCreateName(loginUserInfo.getUserName());
        record.setCreateTime(time);

        breakContractDriverRecordDao.saveEntity(record);
    }

    @Override
    public IPage<BreakContractDriverRecordVO> pageRecord(PageBreakContractDriverRecordParam param) {
        return breakContractDriverRecordDao.pageByParam(param);

    }

    @Override
    public IPage<DriverBreakContractDriverRecordVO> driverPageRecord(DriverPageBreakContractDriverRecordParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        Long userNo = loginUserInfo.getUserNo();
        param.setUserNo(userNo);

        return breakContractDriverRecordDao.driverPageByParam(param);

    }

    /**
     * 创建违约号
     */
    private String childNoGenerate() {
        return uniqueOrderNumService.getUniqueOrderNum(
                LocalDateTimeUtils.convertLocalDateTimeToString(LocalDateTime.now(), LocalDateTimeUtils.DATE_DAY));
    }

}
