package com.clx.performance.service;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.order.params.PageOrderGoodsListParam;
import com.clx.order.params.UpdateEditOrderGoodsParam;
import com.clx.performance.model.OrderGoods;
import com.clx.performance.param.app.OrderGoodsListPageParam;
import com.clx.performance.vo.app.OrderGoodsAPPVO;
import com.clx.performance.vo.feign.OrderGoodsFeignVO;
import com.clx.performance.vo.pc.OrderGoodsVO;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author kavin
 * Date 2023-09-17
 * Time 16:45
 */
public interface OrderGoodsService {
    OrderGoodsVO getOrderGoodsInfoByOrderGoodsNoForPC(String orderGoodsNo);

    OrderGoodsVO getOrderGoodsInfoByOrderGoodsNoForAPP(String orderGoodsNo);

    IPage<OrderGoodsVO> pageOrderGoodsList(PageOrderGoodsListParam param);

    void updateOrderGoodsReduceWeightAndStatus(Integer id, BigDecimal orderChildWeight, Integer orderGoodsStatus);
    void updateOrderGoodsReduceWeightAndStatus(OrderGoods orderGoods, BigDecimal orderChildWeight, Integer orderGoodsStatus);

    IPage<OrderGoodsAPPVO> indexOrderGoodsList(OrderGoodsListPageParam orderGoodsListParam);

    List<OrderGoodsFeignVO> getOrderGoodsListByOrderNo(String orderNo);

    List<OrderGoods> getOrderGoodsList(String orderNo, LocalDateTime lastArriveSendTime);

    String orderCancel(String orderNo);

    BigDecimal orderCancelResidueWeight(String orderNo,String optionType);

    void updateEditOrderGoods(UpdateEditOrderGoodsParam param);
}
