package com.clx.performance.model.breakcontract;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;

/**
 * @author liruixin
 * Date 2023-10-24
 * Time 16:02
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("break_contract_settlement_driver")
public class BreakContractSettlementDriver  implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @TableField("break_contract_party_type")
    @ApiModelProperty("违约方类型：1平台 2货主 3车主")
    private Integer breakContractPartyType;

    @TableField("settlement_no")
    @ApiModelProperty("结算单编号")
    private String settlementNo;

    @TableField("truck_own_user_no")
    @ApiModelProperty("车主用户编号")
    private Long truckOwnUserNo;

    @TableField("truck_own_name")
    @ApiModelProperty("车主名称")
    private String truckOwnName;

    @TableField("driver_user_no")
    @ApiModelProperty("司机用户编号")
    private Long driverUserNo;

    @TableField("driver_name")
    @ApiModelProperty("司机名称")
    private String driverName;

    @TableField("child_no")
    @ApiModelProperty("运单编号")
    private String childNo;

    @TableField("figure")
    @ApiModelProperty("违约金（分）")
    private BigDecimal figure;

    @TableField("break_contract_remark")
    @ApiModelProperty("违约说明")
    private String breakContractRemark;

    @TableField("settle_status")
    @ApiModelProperty("结算状态 0待结算;1已结算")
    private Integer settleStatus;

    @TableField("settle_platform")
    @ApiModelProperty("结算平台 0马上来")
    private Integer settlePlatform;

    @TableField("settle_time")
    @ApiModelProperty("结算时间")
    private LocalDateTime settleTime;

    @TableField("create_by")
    @ApiModelProperty("操作人编号")
    private Long createBy;

    @TableField("create_name")
    @ApiModelProperty("操作人名称")
    private String createName;

    @TableField("create_time")
    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @TableField("modified_time")
    @ApiModelProperty("修改时间")
    private LocalDateTime modifiedTime;

    @Override
    @KeyColumn("id")
    public Integer gainKey() {
    return this.id;
    }
}
