package com.clx.performance.model.breakcontract;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;

/**
 * @author liruixin
 * Date 2023-10-24
 * Time 16:02
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("break_contract_owner_record")
public class BreakContractOwnerRecord   implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @TableField("trigger_type")
    @ApiModelProperty("触发类型：1系统触发 2手动触发")
    private Integer triggerType;

    @TableField("breach_contract_party_type")
    @ApiModelProperty("违约方类型：1平台 2货主 3车主")
    private Integer breachContractPartyType;

    @TableField("break_no")
    @ApiModelProperty(value = "违约单号", example = "")
    private String breakNo;

    @TableField("order_no")
    @ApiModelProperty("违约订单")
    private String orderNo;

    @TableField("owner_user_no")
    @ApiModelProperty("货主用户编号")
    private Long ownerUserNo;

    @TableField("owner_name")
    @ApiModelProperty("货主名称")
    private String ownerName;

    @TableField("figure")
    @ApiModelProperty("违约金（分）")
    private BigDecimal figure;

    @TableField("settlement_no")
    @ApiModelProperty("结算单编号")
    private String settlementNo;

    @TableField("remark")
    @ApiModelProperty("备注")
    private String remark;

    @TableField("create_by")
    @ApiModelProperty(value = "操作人编号", example = "")
    private Long createBy;

    @TableField("create_name")
    @ApiModelProperty(value = "操作人名称", example = "")
    private String createName;

    @TableField("create_time")
    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @TableField("modified_time")
    @ApiModelProperty("修改时间")
    private LocalDateTime modifiedTime;

    @Override
    @KeyColumn("id")
    public Integer gainKey() {
    return this.id;
    }
}
