package com.clx.performance.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.model.IntegralStatistics;
import com.clx.performance.param.pc.PageIntegralStatisticsParam;
import com.clx.performance.sqlProvider.IntegralStatisticsSqlProvider;
import com.clx.performance.sqlProvider.IntegralTruckSqlProvider;
import com.clx.performance.vo.pc.IntegralStatisticsVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.Update;

import java.util.List;

/**
* @Author: aiqinguo
* @Description: 积分排名统计
* @Date: 2023-10-9 11:52:22
* @Version: 1.0
*/

@Mapper
public interface IntegralStatisticsMapper extends BaseMapper<IntegralStatistics> {

    /**
     * @see IntegralStatisticsSqlProvider#pageByParam(com.baomidou.mybatisplus.extension.plugins.pagination.Page, com.clx.performance.param.pc.PageIntegralStatisticsParam)
     */
    @SelectProvider(type = IntegralStatisticsSqlProvider.class, method = "pageByParam")
    IPage<IntegralStatisticsVO> pageByParam(@Param("page") Page<IntegralStatisticsVO> page, @Param("param") PageIntegralStatisticsParam param);

    /**
     * 修改 (更新排名)
     */
    @Update("<script>" +
            "update integral_statistics " +
            "   <trim prefix='set' suffixOverrides=','>" +

            "       <trim prefix='rank = case' suffix='end,'>" +
            "           <foreach collection='list' item='item' index='index'>when id = #{item.id} then #{item.rank} </foreach>" +
            "       </trim>" +

            "   </trim>" +
            "where id in <foreach collection='list' item='item' index='index' separator =',' open='(' close=')'>#{item.id} </foreach>" +
            "</script>")
    int batchUpdateRank(List<IntegralStatistics> list);

}