package com.clx.performance.listener;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.clx.performance.constant.RabbitKeyIntegralConstants;
import com.clx.performance.param.mq.IntegralOrderAddMqParam;
import com.clx.performance.service.IntegralMqHandlerService;
import com.clx.performance.common.MqWrapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @Author: 艾庆国
 * @Description: 积分货单新增 mq
 * @Date: 2023-10-13 11:32:08
 * @Version: 1.0
 */
@Slf4j
@Component
public class IntegralOrderGoodsAddListener {

    @Autowired
    private IntegralMqHandlerService integralMqHandlerService;

    @RabbitListener(queues = RabbitKeyIntegralConstants.INTEGRAL_ORDER_GOODS_ADD_QUEUE)
    public void process(Message message) {
        try{
            log.info("司机积分-新增货单, message:{}", new String(message.getBody()));
            process(JSON.parseObject(new String(message.getBody()), new TypeReference<MqWrapper<IntegralOrderAddMqParam>>(){}).getData());
        }catch (Exception e){
            log.info("司机积分-新增货单 失败",e);
        }
    }

    private void process(IntegralOrderAddMqParam mq){

        integralMqHandlerService.orderGoodsAdd(mq);

    }

}
