package com.clx.performance.dto.gd;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.util.List;

/**
 * @Author: aiqingguo
 * @Description: 收发货地址线路
 * @Date: 2023/2/28 11:02
 * @Version: 1.0
 */
@Getter
@Setter
@ToString
@NoArgsConstructor
@ApiModel(description = "高德线路规划")
public class GdRouteDTO {

    @ApiModelProperty(value = "距离(m)", example = "1")
    private Integer distance;
    @ApiModelProperty(value = "时间s", example = "1")
    private Integer duration;

    @ApiModelProperty(value = "线路轨迹")
    private List<GdPosDTO> posList;

}
