package com.clx.performance.dao.impl.breakcontract;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.breakcontract.BreakContractSettlementOwnerDao;
import com.clx.performance.enums.BreakContractSettlementOwnerEnum;
import com.clx.performance.mapper.breakcontract.BreakContractSettlementOwnerMapper;
import com.clx.performance.model.breakcontract.BreakContractSettlementOwner;
import com.clx.performance.param.pc.breakcontract.carrier.PageCarrierBreakContractSettlementOwnerParam;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

import java.util.Objects;

/**
 * @author liruixin
 * Date 2023-10-24
 * Time 16:02
 */
@Repository
public class BreakContractSettlementOwnerDaoImpl extends BaseDaoImpl<BreakContractSettlementOwnerMapper, BreakContractSettlementOwner, Integer> implements BreakContractSettlementOwnerDao {
    @Override
    public IPage<BreakContractSettlementOwner> pageCarrierBreakContractSettlementOwnerList(PageCarrierBreakContractSettlementOwnerParam param) {
        LambdaQueryWrapper<BreakContractSettlementOwner> query = new LambdaQueryWrapper<>();
        query.eq(BreakContractSettlementOwner :: getDeleteStatus, BreakContractSettlementOwnerEnum.DeleteStatus.NO.getCode());
        query.eq(StringUtils.isNotBlank(param.getOrderNo()),BreakContractSettlementOwner :: getOrderNo,param.getOrderNo());
        query.eq(StringUtils.isNotBlank(param.getSettlementNo()),BreakContractSettlementOwner ::getSettlementNo ,param.getSettlementNo());
        query.eq(Objects.nonNull(param.getBreakContractPartyType()),BreakContractSettlementOwner :: getBreakContractPartyType,param.getBreakContractPartyType());
        query.ge(StringUtils.isNotBlank(param.getBeginTime()), BreakContractSettlementOwner:: getCreateTime,param.getBeginTime());
        query.le(StringUtils.isNotBlank(param.getEndTime()),BreakContractSettlementOwner :: getCreateTime,param.getEndTime());
        query.orderByDesc(BreakContractSettlementOwner::getId);
        return baseMapper.selectPage(Page.of(param.getPage(), param.getPageSize()),query);
    }
}
