package com.clx.performance.dao;

import com.clx.performance.mapper.OrderChildImageMapper;
import com.clx.performance.model.OrderChildImage;
import com.msl.common.base.Optional;
import com.msl.common.dao.BaseDao;

import java.util.List;

/**
 * @Author: aiqinguo
 * @Description: 运单图片
 * @Date: 2023/09/18 11:34:50
 * @Version: 1.0
 */
public interface OrderChildImageDao extends BaseDao<OrderChildImageMapper, OrderChildImage, Integer> {

    boolean deleteLoad(String childNo);
    boolean deleteUnload(String childNo);
    boolean deleteLoadAndUnload(String childNo);

    List<OrderChildImage> getImages(String childNo, Integer type);

    Optional<List<OrderChildImage>> listLoadAndUnload(String childNo);

}
