package com.clx.performance.controller.pc.breakcontract.carrier;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.pc.breakcontract.carrier.PageCarrierBreakContractSettlementOwnerParam;
import com.clx.performance.service.breakcontract.BreakContractSettlementOwnerService;
import com.clx.performance.vo.pc.breakcontract.carrier.CarrierBreakContractSettlementOwnerDetailVO;
import com.clx.performance.vo.pc.breakcontract.carrier.PageCarrierBreakContractSettlementOwnerVO;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;


@Slf4j
@RestController
@RequestMapping(value="/pc/carrier/breakContract")
@Validated
@Api(tags = "承运端-违约结算单（货主）")
@AllArgsConstructor
public class CarrierBreakContractSettlementOwnerController {

    private final BreakContractSettlementOwnerService breakContractSettlementOwnerService;


    @ApiOperation(value = "列表",notes = "<br>By:李瑞新")
    @PostMapping("/pageCarrierBreakContractSettlementOwnerList")
    @UnitCovert(param = false)
    public Result<PageData<PageCarrierBreakContractSettlementOwnerVO>> pageCarrierBreakContractSettlementOwnerList(@RequestBody PageCarrierBreakContractSettlementOwnerParam param) {
        IPage<PageCarrierBreakContractSettlementOwnerVO> page = breakContractSettlementOwnerService.pageCarrierBreakContractSettlementOwnerList(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

    @ApiOperation(value = "导出")
    @PostMapping("/exportCarrierBreakContractSettlementOwnerList")
    public Result exportCarrierBreakContractSettlementOwnerList(@RequestBody  PageCarrierBreakContractSettlementOwnerParam param, HttpServletResponse response) throws Exception {

        SXSSFWorkbook workbook = breakContractSettlementOwnerService.exportCarrierBreakContractSettlementOwnerList(param);
        response.setHeader(HttpHeaders.CONTENT_TYPE, MediaType.APPLICATION_OCTET_STREAM_VALUE);
        workbook.write(response.getOutputStream());
        return null;
    }


    @ApiOperation(value = "详情",notes = "<br>By:李瑞新")
    @GetMapping("/getCarrierBreakContractSettlementOwnerDetail")
    @UnitCovert(param = false)
    public Result<CarrierBreakContractSettlementOwnerDetailVO> getCarrierBreakContractSettlementOwnerDetail(@NotNull(message = "id不能为空") Integer id) {
        return Result.ok(breakContractSettlementOwnerService.getCarrierBreakContractSettlementOwnerDetail(id));
    }

}
