package com.clx.performance.vo.pc.breakcontract.carrier;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.math.BigDecimal;

/**
 * @author liruixin
 * Date 2023-10-24
 * Time 16:02
 */
@Getter
@Setter
@ToString
@NoArgsConstructor
public class BreakContractOwnerRuleVO {
    @ApiModelProperty("id")
    private Integer id;

    @ApiModelProperty(value = "违约方案名称", example = "方案1")
    private String name;

    @ApiModelProperty(value = "状态：1启用 2禁用", example = "1")
    private Integer status;

    @ApiModelProperty("创建时间")
    private String createTime;

    @ApiModelProperty("修改时间")
    private String modifiedTime;


    @ApiModelProperty(value = "自动规则")
    private AutoRule autoRule;
    @ApiModelProperty(value = "手动规则")
    private ManualRule manualRule;

    @Getter
    @Setter
    @ToString
    @NoArgsConstructor
    public static class AutoRule{

        @ApiModelProperty(value = "订单吨数减少")
        private OrderAmountReduceRule orderAmountReduceRule;
        @ApiModelProperty(value = "订单取消")
        private OrderCancelRule orderCancelRule;
    }

    @Getter
    @Setter
    @ToString
    @NoArgsConstructor
    public static class ManualRule{

        private Integer id;
    }

    @Getter
    @Setter
    @ToString
    @NoArgsConstructor
    public static class OrderAmountReduceRule {
        @ApiModelProperty(value = "总运费*X%", example = "1.23")
        private BigDecimal ratio;
    }

    @Getter
    @Setter
    @ToString
    @NoArgsConstructor
    public static class OrderCancelRule {
        @ApiModelProperty(value = "挂单前，总运费*X%", example = "1.23")
        private BigDecimal beforeRatio;
        @ApiModelProperty(value = "挂单后，总运费*X%", example = "1.23")
        private BigDecimal afterRatio;
        @ApiModelProperty(value = "挂单后，车辆违约金X元/小时.车", example = "1.23")
        private BigDecimal afterFigurePerHour;
    }

}
