package com.clx.performance.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;

@Getter
@AllArgsConstructor
@SuppressWarnings("all")
public enum TruckDemandEnum {
    ;
    @Getter
    @AllArgsConstructor
    public enum TruckType {
        PLATFORM_CAR(1, "平台车辆"),
        PLATFORM_ANY_CAR(2, "部分平台车辆"),
        OWNER_CAR(3, "自有车辆");

        private final Integer code;
        private final String msg;

        public static Optional<TruckType> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }
    }

}
