package com.clx.performance.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;

public enum OrderGoodsStatusEnum {
    ;

    @Getter
    @AllArgsConstructor
    public enum Status {

        CREATED(10, "已挂单"),

        PAYING(20, "挂单中"),

        GO_TO_SEND(30, "运输中"),
        SUCCESS(40, "已完成"),
        CANCEL(50, "已取消"),
        COMPLETED(60, "已完结")
        ;

        private final Integer code;
        private final String name;

        public static Optional<Status> getByCode(Integer code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }
    }


}
