package com.clx.performance.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;


@Getter
@AllArgsConstructor
public enum DtsOperationTypeEnum {

    // 数据操作类型
    INSERT(1, "INSERT"),
    UPDATE(2, "UPDATE"),
    DELETE(3, "DELETE"),
    DDL(4, "DDL"),
    BEGIN(5, "BEGIN"),
    COMMIT(6, "COMMIT"),
    HEARTBEAT(7, "HEARTBEAT"),
    CHECKPOINT(8, "CHECKPOINT"),
    UNKNOWN(9, "UNKNOWN"),
    ;


    private final Integer code;

    private final String msg;

    public static String getMsg(Integer code) {
        return Arrays.stream(values())
                .filter(e -> Objects.equals(e.code, code))
                .findFirst()
                .map(DtsOperationTypeEnum::getMsg)
                .orElse("");
    }

    public static Optional<DtsOperationTypeEnum> getByMsg(String msg) {
        return Stream.of(values()).filter(q -> Objects.equals(q.getMsg(), msg)).findFirst();
    }

}
