package com.clx.performance.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;

public enum BreakContractRecordEnum {
    ;

    @Getter
    @AllArgsConstructor
    public enum TriggerType {
        SYSTEM(1, "系统触发"),
        MANUAL(2, "手动触发"),
        ;

        private final Integer code;
        private final String msg;

        public static Optional<TriggerType> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }
    }
    @Getter
    @AllArgsConstructor
    public enum BreachContractPartyType {
        PLATFORM(1, "平台"),
        OWNER(2, "货主"),
        DRIVER(3, "司机"),
        ;

        private final Integer code;
        private final String msg;

        public static Optional<BreachContractPartyType> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }
    }

}
