package com.clx.performance.job;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSON;
import cn.hutool.json.JSONUtil;
import com.clx.performance.component.ThirdComponent;
import com.clx.performance.dao.OrderChildDao;
import com.clx.performance.dao.OrderChildSyncTransportInvoiceRecordDao;
import com.clx.performance.enums.TransportSyncTypeEnum;
import com.clx.performance.feign.TransportFeignService;
import com.clx.performance.listener.OrderChildSyncTransportListener;
import com.clx.performance.model.OrderChild;
import com.clx.performance.model.OrderChildSyncTransportInvoiceRecord;
import com.clx.performance.param.feign.transport.ThirdOrderChildRiskStatusParam;
import com.msl.common.result.Result;
import com.xxl.job.core.handler.annotation.XxlJob;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.util.LinkedList;
import java.util.List;

@Slf4j
@Component
@AllArgsConstructor
public class OrderChildSyncTransportInvoiceExceptionJob {

    private final OrderChildSyncTransportInvoiceRecordDao orderChildSyncTransportInvoiceRecordDao;

    private final OrderChildSyncTransportListener orderChildPaySync;

    private final OrderChildDao orderChildDao;

    private final TransportFeignService transportFeignService;

    /**
     * 同步网络货运
     */
    @XxlJob("orderChildSyncTransportInvoiceExceptionJob")
    @Transactional(rollbackFor = Exception.class)
    public void orderChildSyncTransportInvoiceExceptionJob() {
        //只查询同步异常的网络货运任务
        List<OrderChildSyncTransportInvoiceRecord> recordList = orderChildSyncTransportInvoiceRecordDao.selectListForJob();
        if (CollectionUtil.isEmpty(recordList)) {
            return;
        }
        List<Integer> ids = new LinkedList<>();

        for (OrderChildSyncTransportInvoiceRecord record : recordList) {
            String data = transportFeignService.getRiskStatus(ThirdOrderChildRiskStatusParam.builder().childNo(record.getChildNo()).build()).getData();
            String decrypt = ThirdComponent.decrypt(data);
            Result bean = JSONUtil.toBean(decrypt, Result.class);
            if (bean.succeed()) {
                JSON json = JSONUtil.parse(bean.getData());
                Object status = json.getByPath("status");
                ids.add(record.getId());

                if (ObjectUtil.equal(status, 1)) {
                    OrderChild orderChild = orderChildDao.getByChildNo(record.getChildNo()).get();
                    orderChildPaySync.transportOrderChildProcess(orderChild);
                } else {
                    Object riskReason = json.getByPath("riskReason");
                    OrderChildSyncTransportInvoiceRecord entity = new OrderChildSyncTransportInvoiceRecord();
                    entity.setChildNo(json.getByPath("childNo").toString());
                    entity.setType(TransportSyncTypeEnum.Type.NO_PASS.getCode());
                    entity.setRemark(riskReason == null ? "" : riskReason.toString());
                    orderChildSyncTransportInvoiceRecordDao.saveEntity(entity);
                }
            }
        }

        orderChildSyncTransportInvoiceRecordDao.deleteByKeys(ids);
    }
}
