package com.clx.performance.sqlProvider.integral;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.param.pc.integral.PageIntegralTruckRuleParam;
import com.clx.performance.vo.pc.integral.AppIntegralTruckRuleVO;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.jdbc.SQL;

public class IntegralTruckRuleProvider {

    public String pageRule(@Param("page") Page<AppIntegralTruckRuleVO> page, @Param("param") PageIntegralTruckRuleParam param) {
        return new SQL(){{
            SELECT(" id, name, " +
                    " integral_ratio_begin as integralRatioBegin, integral_ratio_end as integralRatioEnd, " +
                    " income_begin as incomeBegin, income_end as incomeEnd, " +
                    " status, " +
                    " date_format(create_time, '%Y-%m-%d %H:%i:%s') as createTime, " +
                    " date_format(modified_time, '%Y-%m-%d %H:%i:%s') as modifiedTime "
            );
            FROM("integral_truck_rule ");

            ORDER_BY("create_time desc");
        }}.toString();
    }

}
