package com.clx.performance.dao.impl.loan;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.loan.OwnerRepaymentDao;
import com.clx.performance.enums.loan.OwnerRePaymentEnum;
import com.clx.performance.mapper.loan.OwnerRepaymentMapper;
import com.clx.performance.model.loan.OwnerRepayment;
import com.clx.performance.param.pc.loan.carrier.PageCarrierOwnerRepaymentParam;
import com.clx.performance.param.pc.loan.carrier.PageOwnerRepaymentOfOwner;
import com.clx.performance.vo.pc.loan.carrier.OwnerRepaymentVO;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Objects;

/**
 * @author kavin
 * Date 2024-01-20
 * Time 13:31
 */
@Repository
public class OwnerRepaymentDaoImpl extends BaseDaoImpl<OwnerRepaymentMapper, OwnerRepayment, Integer> implements OwnerRepaymentDao {
    @Override
    public IPage<OwnerRepayment> pageOwnerRepayment(PageCarrierOwnerRepaymentParam param) {
        LambdaQueryWrapper<OwnerRepayment> query = new LambdaQueryWrapper<>();
        if(Objects.nonNull(param.getRepaymentNo())){
            query.eq(OwnerRepayment :: getRepaymentNo,param.getRepaymentNo());
        }
        if(StringUtils.isNotBlank(param.getOwnerUserNo())){
            query.eq(OwnerRepayment :: getOwnerUserNo,param.getOwnerUserNo());
        }
        if(StringUtils.isNotBlank(param.getOwnerUserName())){
            query.like(OwnerRepayment :: getOwnerUserName,param.getOwnerUserName());
        }
        if(StringUtils.isNotBlank(param.getMobile())){
            query.like(OwnerRepayment :: getMobile,param.getMobile());
        }
        if(Objects.nonNull(param.getLoanNo())){
            query.like(OwnerRepayment :: getLoanNo,param.getLoanNo());
        }
        if(Objects.nonNull(param.getStatus())){
            query.like(OwnerRepayment :: getStatus,param.getStatus());
        }
        if(Objects.nonNull(param.getBeOverdue())){
            query.like(OwnerRepayment :: getBeOverdue,param.getBeOverdue());
        }
        if(Objects.nonNull(param.getInStatusList())){
            query.in(OwnerRepayment :: getStatus,param.getInStatusList());
        }
        query.orderByDesc(OwnerRepayment :: getCreateTime);
        return baseMapper.selectPage(Page.of(param.getPage(), param.getPageSize()),query);
    }

    @Override
    public IPage<OwnerRepaymentVO> pageByParam(PageOwnerRepaymentOfOwner param) {
        Page<OwnerRepaymentVO> page = Page.of(param.getPage(), param.getPageSize());
        return baseMapper.pageByParam(page,param);
    }

    @Override
    public List<OwnerRepayment> selectListByStatusAndOwnerUserNo(Integer status, Long ownerUserNo) {
        return baseMapper.selectList(lQrWrapper().eq(OwnerRepayment::getOwnerUserNo, ownerUserNo)
                .lt(OwnerRepayment::getStatus, status)
        );
    }

    @Override
    public void updateRePay(OwnerRepayment ownerRepayment) {
        update(lUdWrapper().eq(OwnerRepayment::getId,  ownerRepayment.getId())
                .set(OwnerRepayment::getRemittanceIdentificationCode, ownerRepayment.getRemittanceIdentificationCode())
                .set(OwnerRepayment::getStatus, ownerRepayment.getStatus())
                .set(OwnerRepayment::getRunningWaterOpenNo,ownerRepayment.getRunningWaterOpenNo())
                .set(OwnerRepayment::getMerchantRunningWaterNo,ownerRepayment.getMerchantRunningWaterNo())
                .set(OwnerRepayment::getPayChannel,ownerRepayment.getPayChannel())
                .set(OwnerRepayment::getCloseOrderTime, ownerRepayment.getCloseOrderTime())
                .set(OwnerRepayment::getPayment,ownerRepayment.getPayment())
                .set(OwnerRepayment::getPaymentAccount,ownerRepayment.getPaymentAccount())
                .set(OwnerRepayment::getOperateBy, ownerRepayment.getOperateBy())
                .set(OwnerRepayment::getOperateTime, ownerRepayment.getOperateTime())


        );
    }

    @Override
    public void updateStatusById(OwnerRepayment ownerRepayment) {
        update(lUdWrapper().eq(OwnerRepayment::getId,  ownerRepayment.getId())
                .set(OwnerRepayment::getStatus, ownerRepayment.getStatus())
        );
    }

}
