package com.clx.performance.param.feign;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;


@Getter
@Setter
public class OrderAdjustTonnageDownParam {

    @NotBlank(message = "订单编号不能为空")
    @ApiModelProperty("订单编号")
    private String orderNo;

    @NotNull(message = "调整货物吨数不能为空")
    @ApiModelProperty(value = "调整货物吨数")
    private BigDecimal weight;


    @NotNull(message = "拉运重量不能为空")
    @ApiModelProperty(value = "拉运重量")
    private BigDecimal transportWeight;

    @NotNull(message = "有效运费不能为空")
    @ApiModelProperty("有效运费")
    private BigDecimal validFreightPrice;

    @NotNull(message = "违约金方案id不能为空")
    @ApiModelProperty("违约金方案id")
    private Integer liquidatedDamagesPlanId;

}
