package com.clx.performance.sqlProvider;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.param.pc.PageIntegralTruckParam;
import com.clx.performance.param.pc.PageIntegralTruckRankParam;
import com.clx.performance.vo.pc.IntegralTruckVO;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.jdbc.SQL;

import java.util.Objects;

public class IntegralTruckSqlProvider {

    public String pageByParam(@Param("page") Page<IntegralTruckVO> page, @Param("param") PageIntegralTruckParam param) {
        return new SQL(){{

            SELECT(" id, truck_no, " +
                    " driver_name, driver_mobile, " +
                    " echelon, integral, rank, " +
                    " date_format(create_time, '%Y-%m-%d %H:%i:%s') as createTime, " +
                    " date_format(modified_time, '%Y-%m-%d %H:%i:%s') as modifiedTime ");

            FROM("integral_truck");

            if (StringUtils.isNotBlank(param.getTruckNo())) {WHERE("truck_no = #{param.truckNo}");}
            if (StringUtils.isNotBlank(param.getDriverMobile())) {WHERE("driver_mobile = #{param.driverMobile}");}
            if (!Objects.isNull(param.getEchelon())) {WHERE("echelon = #{param.echelon}");}

            if (StringUtils.isNotBlank(param.getBeginTime())) {WHERE("create_time >= #{param.beginTime}");}
            if (StringUtils.isNotBlank(param.getEndTime())) {WHERE("create_time <= #{param.endTime}");}

            ORDER_BY("create_time desc");
        }}.toString();
    }

    public String pageTruckRank(@Param("page") Page<IntegralTruckVO> page) {
        return new SQL(){{

            SELECT(" id, truck_no, " +
                    " driver_name, driver_mobile, " +
                    " echelon, integral, rank, " +
                    " date_format(create_time, '%Y-%m-%d %H:%i:%s') as createTime, " +
                    " date_format(modified_time, '%Y-%m-%d %H:%i:%s') as modifiedTime ");

            FROM("integral_truck");
            ORDER_BY("integral desc, create_time desc");
        }}.toString();
    }

}
