package com.clx.performance.dao.impl.breakcontract;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.breakcontract.BreakContractSettlementOwnerDetailDao;
import com.clx.performance.mapper.breakcontract.BreakContractSettlementOwnerDetailMapper;
import com.clx.performance.model.breakcontract.BreakContractSettlementOwnerDetail;
import com.clx.performance.param.pc.breakcontract.carrier.PageCarrierBreakContractSettlementOwnerDetailParam;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

import java.util.Objects;

/**
 * @author liruixin
 * Date 2023-10-24
 * Time 16:02
 */
@Repository
public class BreakContractSettlementOwnerDetailDaoImpl extends BaseDaoImpl<BreakContractSettlementOwnerDetailMapper, BreakContractSettlementOwnerDetail, Integer> implements BreakContractSettlementOwnerDetailDao {
    @Override
    public IPage<BreakContractSettlementOwnerDetail> pageCarrierBreakContractSettlementOwnerDetailList(PageCarrierBreakContractSettlementOwnerDetailParam param) {
        LambdaQueryWrapper<BreakContractSettlementOwnerDetail> query = new LambdaQueryWrapper<>();
        query.eq(StringUtils.isNotBlank(param.getOrderNo()),BreakContractSettlementOwnerDetail :: getOrderNo,param.getOrderNo());
        query.eq(Objects.nonNull(param.getOwnerUserNo()),BreakContractSettlementOwnerDetail ::getOwnerUserNo ,param.getOwnerUserNo());
        query.eq(StringUtils.isNotBlank(param.getOwnerName()),BreakContractSettlementOwnerDetail :: getOwnerName,param.getOwnerName());
        query.eq(Objects.nonNull(param.getBreakContractPartyType()),BreakContractSettlementOwnerDetail :: getBreakContractPartyType,param.getBreakContractPartyType());
        query.orderByDesc(BreakContractSettlementOwnerDetail::getId);
        return baseMapper.selectPage(Page.of(param.getPage(), param.getPageSize()),query);
    }

}
