package com.clx.performance.dao.impl.breakcontract;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.breakcontract.BreakContractOwnerRecordDao;
import com.clx.performance.enums.BreakContractSettlementDriverEnum;
import com.clx.performance.mapper.breakcontract.BreakContractOwnerRecordMapper;
import com.clx.performance.model.breakcontract.BreakContractOwnerRecord;
import com.clx.performance.param.pc.breakcontract.carrier.PageBreakContractOwnerRecordParam;
import com.clx.performance.param.pc.breakcontract.owner.PageOwnerBreakContractOwnerRecordParam;
import com.clx.performance.vo.pc.breakcontract.carrier.BreakContractOwnerRecordVO;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

import java.util.Objects;

/**
 * @author liruixin
 * Date 2023-10-24
 * Time 16:02
 */
@Repository
public class BreakContractOwnerRecordDaoImpl extends BaseDaoImpl<BreakContractOwnerRecordMapper, BreakContractOwnerRecord, Integer> implements BreakContractOwnerRecordDao {

    @Override
    public IPage<BreakContractOwnerRecordVO> pageByParam(PageBreakContractOwnerRecordParam param) {
        Page<BreakContractOwnerRecordVO> page = Page.of(param.getPage(), param.getPageSize());
        return baseMapper.pageByParam(page,param);
    }

    @Override
    public IPage<BreakContractOwnerRecord> pageOwnerBreakContractOwnerRecordList(PageOwnerBreakContractOwnerRecordParam param) {
        LambdaQueryWrapper<BreakContractOwnerRecord> query = new LambdaQueryWrapper<>();
        query.eq(StringUtils.isNotBlank(param.getOrderNo()),BreakContractOwnerRecord :: getOrderNo,param.getOrderNo());
        query.eq(Objects.nonNull(param.getOwnerUserNo()),BreakContractOwnerRecord :: getOwnerUserNo,param.getOwnerUserNo());
        query.eq(Objects.nonNull(param.getBreakContractPartyType()),BreakContractOwnerRecord :: getBreakContractPartyType,param.getBreakContractPartyType());
        query.eq(Objects.nonNull(param.getPayStatus()),BreakContractOwnerRecord :: getPayStatus,param.getPayStatus());
        if(Objects.equals(param.getBreakContractPartyType(), BreakContractSettlementDriverEnum.BreakContractPartyType.PLATFORM.getCode())){
            query.ge(StringUtils.isNotBlank(param.getBeginTime()), BreakContractOwnerRecord:: getPayTime,param.getBeginTime());
            query.le(StringUtils.isNotBlank(param.getEndTime()),BreakContractOwnerRecord :: getPayTime,param.getEndTime());
        }else{
            query.ge(StringUtils.isNotBlank(param.getBeginTime()), BreakContractOwnerRecord:: getCreateTime,param.getBeginTime());
            query.le(StringUtils.isNotBlank(param.getEndTime()),BreakContractOwnerRecord :: getCreateTime,param.getEndTime());
        }
        query.orderByDesc(BreakContractOwnerRecord::getId);
        return baseMapper.selectPage(Page.of(param.getPage(), param.getPageSize()),query);
    }

    @Override
    public boolean uploadPayTime(BreakContractOwnerRecord breakContractOwnerRecord) {
        return update(lUdWrapper()
                .eq(BreakContractOwnerRecord::getSettlementNo, breakContractOwnerRecord.getSettlementNo())
                .set(BreakContractOwnerRecord::getPayStatus, breakContractOwnerRecord.getPayStatus())
                .set(BreakContractOwnerRecord::getPayTime, breakContractOwnerRecord.getPayTime())
        );
    }
}
