package com.clx.performance.vo.pc.loan.owner;

import com.clx.performance.enums.loan.OwnerLoanRecordEnum;
import com.clx.performance.enums.loan.OwnerRePaymentEnum;
import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.Objects;

/**
 * @ClassName OwnerRepayment
 * @Description
 * @Author kavin
 * @Date 2024/1/20 15:18
 * @Version 1.0
 */
@Getter
@Setter
public class ExportOwnerRepaymentVO {

    private Integer id;

    
    @Schema(description="货主编码")
    private String ownerUserNo;

    
    @Schema(description="货主名称")
    private String ownerUserName;

    
    @Schema(description="联系电话")
    private String mobile;

    
    @Schema(description="交易流水号（第三方）")
    private String runningWaterOpenNo;

    @Schema(description="商户流水号")
    private String merchantRunningWaterNo;

    
    @Schema(description="还款单号")
    private Long repaymentNo;

    @Schema(description="还款金额")
    private BigDecimal repaymentBalance;

    public BigDecimal getRepaymentBalance(){
        return Objects.isNull(repaymentBalance)?BigDecimal.ZERO:repaymentBalance.movePointLeft(2);
    }


    
    @Schema(description="付款方")
    private String payment;

    
    @Schema(description="付款账户")
    private String paymentAccount;


    @Schema(description="汇款识别码")
    private String remittanceIdentificationCode;


    
    @Schema(description="收款方")
    private String payee;

    
    @Schema(description="收款账户")
    private String payeeAccount;


    @Schema(description="货物名称")
    private String goodsName;


    @Schema(description="借款单号")
    private Long loanNo;


    @Schema(description="10 待付款 40 付款中 50 付款成功 60 付款失败")
    private Integer status;


    @Schema(description="10 待付款 40 付款中 50 付款成功 60 付款失败")
    private String statusMsg;

    public String getStatusMsg(){
        return OwnerRePaymentEnum.Status.getMsgByCode(status);
    }


    
    @Schema(description="支付渠道 1 订单支付 2 转账支付")
    private Integer payChannel;

    @Schema(description="支付渠道 1 订单支付 2 转账支付")
    private String payChannelMsg;

    public String getPayChannelMsg(){
        return OwnerLoanRecordEnum.PayChannel.getMsgByCode(payChannel);
    }

    
    @Schema(description="10 未逾期  20 已逾期")
    private Integer beOverdue;

    @Schema(description="10 未逾期  20 已逾期")
    private String beOverdueMsg;

    public String getBeOverdueMsg(){
        return OwnerRePaymentEnum.BeOverdue.getMsgByCode(beOverdue);
    }
    
    @Schema(description="借款归还时间")
    private String loanRepaymentTime;

    
    @Schema(description="操作时间")
    private String operateTime;

    
    @Schema(description="操作人")
    private String operateBy;

    
    @Schema(description="创建人")
    private String createBy;

    
    @Schema(description="生成付款申请单时间")
    private String createTime;

    
    @Schema(description="修改时间")
    private String modifiedTime;


    @Schema(description="收款银行")
    private String payeeBank;


    @Schema(description="收款行号")
    private String payeeBankCode;

}
