package com.clx.performance.vo.app;

import cn.hutool.json.JSONUtil;
import com.clx.performance.enums.OrderChildEnum;
import com.clx.performance.enums.OrderGoodsEnum;
import com.clx.performance.enums.SyncPlatformEnum;
import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

/**
* @Author: aiqinguo
* @Description: 运单表
* @Date: 2023/09/19 16:49:06
* @Version: 1.0
*/

@Schema(description = "运单表")
@Getter
@Setter
@ToString
@NoArgsConstructor
public class OrderChildVO {

    @Schema(description = "id", example = "1")
    private Integer id;
    @Schema(description = "用户编号", example = "10000000000")
    private Long userNo;
    @Schema(description = "货主用户编号", example = "100000000")
    private Long ownerUserNo;
    @Schema(description = "货主名称", example = "张三")
    private String ownerName;
    @Schema(description = "运单编号", example = "100000000")
    private String childNo;
    @Schema(description = "货单编号", example = "100000000")
    private String orderGoodsNo;
    @Schema(description = "订单编号", example = "10000000000")
    private String orderNo;

    @Schema(description = "货物id", example = "1")
    private Integer goodsId;
    @Schema(description = "货物名称", example = "煤")
    private String goodsName;
    @MoneyOutConvert
    @Schema(description = "运费单价（元）", example = "1.23")
    private BigDecimal freightPrice;
    @Schema(description = "发货地址id", example = "1")
    private Integer sendAddressId;
    @Schema(description = "发货地址", example = "朝阳")
    private String sendAddress;
    @Schema(description = "收货地址id", example = "2")
    private Integer receiveAddressId;
    @Schema(description = "收货地址", example = "西城")
    private String receiveAddress;
    @Schema(description = "最晚装货时间", example = "")
    private String loadDeadline;

    @Schema(description = "车主id", example = "1")
    private Long truckOwnUserNo;
    @Schema(description = "车主姓名", example = "李四")
    private String truckOwnName;
    @Schema(description = "车辆ID", example = "1")
    private Integer truckId;
    @Schema(description = "车牌号", example = "京A12345")
    private String truckNo;
    @Schema(description = "载重（单位吨）", example = "12.34")
    private BigDecimal truckLoad;
    @Schema(description = "车型", example = "挂车")
    private String truckModel;

    @Schema(description = "司机用户编号", example = "1000000")
    private Long driverUserNo;
    @Schema(description = "司机姓名", example = "张三")
    private String driverName;
    @Schema(description = "司机手机号", example = "130000000")
    private String driverMobile;

    @Schema(description = "装货毛重（单位吨）", example = "1.23")
    private BigDecimal loadRough;
    @Schema(description = "装货皮重（单位吨）", example = "1.23")
    private BigDecimal loadTare;
    @Schema(description = "装货净重（单位吨）", example = "1.23")
    private BigDecimal loadNet;
    @Schema(description = "卸货毛重（单位吨）", example = "1.23")
    private BigDecimal unloadRough;
    @Schema(description = "卸货皮重（单位吨）", example = "1.23")
    private BigDecimal unloadTare;
    @Schema(description = "卸货净重（单位吨）", example = "1.23")
    private BigDecimal unloadNet;
    @Schema(description = "卸货磅单编号", example = "url")
    private String unloadPoundNo;

    @Schema(description = "拉运重量（单位吨）", example = "1.23")
    private BigDecimal weight;
    @Schema(description = "运费（元）", example = "1.23")
    @MoneyOutConvert
    private BigDecimal freight;
    @Schema(description = "损耗单价(分)", example = "1.23")
    @MoneyOutConvert
    private BigDecimal lossPrice;
    @Schema(description = "合同运费单价", example = "1.23")
    @MoneyOutConvert
    private BigDecimal orderFreightPrice;

    @Schema(description = "取消原因", example = "取消原因类型：1个人原因, 2价格不合适, 3无法装货, 4车辆原因, 5交通管制, 6交通事故, 7无法找到地址, 8排队时间较长, 9其他原因")
    private Integer cancelType;
    @Schema(description = "取消原因", example = "抢错了")
    private String cancelRemark;
    @Schema(description = "司机取消详细原因", example = "司机取消详细原因")
    private String cancelDetail;
    @Schema(description = "磅单审核状态 0 待审核 1 审核通过 2 审核驳回", example = "0")
    private Integer poundStatus;
    @Schema(description = "磅单审核驳回原因", example = "交货信息错误")
    private String poundRemark;
    @Schema(description = "审核驳回类型：1装车 2卸车 3装车+卸车", example = "1")
    private Integer poundRejectType;
    @Schema(description = "状态", example = "0")
    private Integer status;
    @Schema(description = "运输状态 0非运输中 1运输中", example = "1")
    private Integer transitStatus;
    public Integer getTransitStatus() {
        return status==null || !OrderChildEnum.TRANSIT_lIST.contains(status)? 0 : 1;
    }

    @Schema(description = "支付时间(抢单时间)", example = "")
    private String payTime;
    @Schema(description = "装车时间", example = "")
    private String loadTime;
    @Schema(description = "卸车时间", example = "")
    private String unloadTime;
    @Schema(description = "司机确认交货时间", example = "")
    private LocalDateTime confirmTime;
    @Schema(description = "结算时间", example = "")
    private String settleTime;
    @Schema(description = "取消时间", example = "")
    private String cancelTime;
    @Schema(description = "完成时间", example = "")
    private String finishTime;
    @Schema(description = "创建时间", example = "")
    private String createTime;
    @Schema(description = "修改时间", example = "")
    private String modifiedTime;

    @Schema(description = "装车磅单图片列表")
    private List<String> loadImageList;

    @Schema(description = "卸车磅单图片列表")
    private List<String> unloadImageList;

    @Schema(description = "发货地址详情")
    private Address sendAddressInfo;
    @Schema(description = "发货地址详情")
    private Address receiveAddressInfo;

    @Schema(description = "总运费（元）", example = "1.23")
    private BigDecimal totalFreight;
    public BigDecimal getTotalFreight() {
        return freightPrice.multiply(weight).setScale(2, RoundingMode.HALF_UP);
    }

    @Schema(description="状态MSG")
    public String statusMsg;
    public String getStatusMsg() {
        return OrderChildEnum.Status.getByCode(status).get().getName();
    }

    @Schema(description="货物类型名称")
    public String goodTypeName;


    @Schema(description="'最晚到达目的地时间'")
    private String lastArriveReceiveTime;
    @Schema(description="最晚到达货源地时间")
    private String lastArriveSendTime;
    @Schema(description="最晚装货时间")
    private String lastLoadTime;

    @MoneyOutConvert
    @Schema(description="平台服务费")
    private BigDecimal platformServiceFee;
    @Schema(description="平台服务费费率%")
    private BigDecimal platformServiceFeeRate;
    @MoneyOutConvert
    @Schema(description="接单保证金（元/车）")
    private BigDecimal deposit;

    //结算信息
    @Schema(description = "实际运费", example = "1.23")
    @MoneyOutConvert
    private BigDecimal realFreight;
    @Schema(description = "货损金额", example = "1.23")
    @MoneyOutConvert
    private BigDecimal lossFreight;
    @Schema(description = "预付运费金额", example = "1.23")
    @MoneyOutConvert
    private BigDecimal prepayFreight;
    @Schema(description = "结算金额", example = "1.23")
    @MoneyOutConvert
    private BigDecimal settlementFreight;



    //运单详情增加字段
    @Schema(description = "亏吨重量", example = "1.23")
    private BigDecimal lossWeight;
    @Schema(description = "亏吨扣款", example = "1.23")
    @MoneyOutConvert
    private BigDecimal lossAmount;

    @Schema(description="可卸车时间段开始")
    private String unloadBeginTime;

    @Schema(description="可卸车时间段结束")
    private String unloadEndTime;

    @Schema(description="可装车时间段开始")
    private String loadBeginTime;

    @Schema(description="可装车时间段结束")
    private String loadEndTime;
    @Schema(description = "车辆未开启中交兴路的提示信息")
    private String notOpenZJXLMsg;

    @Schema(description="接单保证金 平台服务费费率 弹窗和文案显示 0 不显示  1 显示")
    private Integer goodsOrderDetailShow =  0;

    /* 20240730 增加货源地信息 */

    @Schema(description = "货源地现场联系人")
    private String sendContact;

    @Schema(description = "货源地联系人手机号")
    private String sendContactPhone;

    @Schema(description = "发货-是否需要系统排队 0 否  1 是")
    private Integer sendWaitSystem;

    @Schema(description = "发货-是否需要系统排队 描述：  需要 不需要")
    public String getSendWaitSystemMsg() {
        return OrderGoodsEnum.SendWaitSystemMsgEnum.getMsgByCode(sendWaitSystem);
    }

    @Schema(description = "发货-排队系统名称")
    private String sendWaitSystemName;

    @Schema(description = "发货-排队系统形式  1:小程序  2:app")
    private Integer sendWaitMode;

    @Schema(description = "发货-排队系统形式 描述：  微信小程序  app")
    public String getSendWaitModeMsg() {
        return OrderGoodsEnum.SendWaitModeEnum.getMsgByCode(sendWaitMode);
    }

    @Schema(description = "发货采样位置")
    private String sendQualityPosition;
    @Schema(description = "发货地采样视频")
    private String sendSamplingVideo;
    @Schema(description = "发货地采样照片")
    private String sendSamplingPic;
    @Schema(description = "监装联系人")
    private String superviseContacts;
    @Schema(description = "监装联系人电话")
    private String superviseMobile;

    @Schema(description = "是否解除监装限制 0 未解除 1 解除")
    private Integer removeLoadLimitStatus;


    @Schema(description = "发货地采样照片")
    public List<String> getSendSamplingPicList() {
        if (StringUtils.isNotBlank(sendSamplingPic)) {
            return JSONUtil.toList(sendSamplingPic, String.class);
        }
        return new ArrayList<>();
    }

    @Schema(description = "发货地采样视频")
    public List<String> getSendSamplingVideoList() {
        if (StringUtils.isNotBlank(sendSamplingVideo)) {
            return JSONUtil.toList(sendSamplingVideo, String.class);
        }
        return new ArrayList<>();
    }

    @Schema(description = "目的地现场联系人")
    private String receiveContact;

    @Schema(description = "目的地联系人手机号")
    private String receiveContactPhone;

    @Schema(description = "收货-是否需要系统排队 0 否  1 是")
    private Integer receiveWaitSystem;

    @Schema(description = "收货-是否需要系统排队 描述：  需要 不需要")
    public String getReceiveWaitSystemMsg() {
        return OrderGoodsEnum.SendWaitSystemMsgEnum.getMsgByCode(receiveWaitSystem);
    }

    @Schema(description = "收货-排队系统名称")
    private String receiveWaitSystemName;

    @Schema(description = "收货-排队系统形式  1:小程序  2:app")
    private Integer receiveWaitMode;

    @Schema(description = "收货-排队系统形式 描述：  微信小程序  app")
    public String getReceiveWaitModeMsg() {
        return OrderGoodsEnum.SendWaitModeEnum.getMsgByCode(receiveWaitMode);
    }

    @Schema(description = "收货采样位置")
    private String receiveQualityPosition;
    @Schema(description = "收货地采样视频")
    private String receiveSamplingVideo;
    @Schema(description = "收货地采样照片")
    private String receiveSamplingPic;
    @Schema(description = "监卸联系人")
    private String superviseUnloadContacts;
    @Schema(description = "监卸联系人电话")
    private String superviseUnloadMobile;

    @Schema(description = "收货地采样照片")
    public List<String> getReceiveSamplingPicList() {
        if (StringUtils.isNotBlank(receiveSamplingPic)) {
            return JSONUtil.toList(receiveSamplingPic, String.class);
        }
        return new ArrayList<>();
    }

    @Schema(description = "收货地采样视频")
    public List<String> getReceiveSamplingVideoList() {
        if (StringUtils.isNotBlank(receiveSamplingVideo)) {
            return JSONUtil.toList(receiveSamplingVideo, String.class);
        }
        return new ArrayList<>();
    }

    @Schema(description = "订单来源")
    private Integer orderSource;
    private String orderSourceMsg;
    public String getOrderSourceMsg() {
        return SyncPlatformEnum.Source.getNameByCode(orderSource);
    }
}
