package com.clx.performance.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.time.LocalDateTime;



@Getter
@Setter
@NoArgsConstructor
@TableName(autoResultMap = true)
public class OrderChildExceptionReportOperationLog implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;                             //id
    private String reportNo;                         //异常上报编号
    private Integer type;                           //操作事项编码
    private String result;                          //处理结果
    private Long createBy;                          //操作人编号
    private String createName;                      //操作人名称
    private LocalDateTime createTime;                      //创建时间
    private LocalDateTime modifiedTime;                    //修改时间

    @KeyColumn("id")
    @Override
    public Integer gainKey() {
        return id;
    }
}