package com.clx.performance.controller.pc.loan.carrier;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.pc.loan.carrier.PageOwnerLoanAccountParam;
import com.clx.performance.service.loan.OwnerLoanAccountService;
import com.clx.performance.vo.pc.loan.carrier.CarrierOwnerLoanAccountVO;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Slf4j
@RestController
@RequestMapping(value="/pc/carrier/ownerLoanAccount")
@Validated
@Tag(name = "承运端-借款账户")
public class CarrierOwnerLoanAccountController {

    @Autowired
    private OwnerLoanAccountService ownerLoanAccountService;


    @Operation(summary = "分页搜索货主借款账户列表",description = "<br>By:艾庆国")
    @PostMapping("/pageOwnerLoanAccount")
    @UnitCovert(param = false)
    public Result<PageData<CarrierOwnerLoanAccountVO>> pageOwnerLoanAccount(@RequestBody @Validated PageOwnerLoanAccountParam param) {
        IPage<CarrierOwnerLoanAccountVO> page = ownerLoanAccountService.pageOwnerLoanAccount(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

}
