package com.clx.performance.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.open.sdk.callback.message.OrderInfoMessage;
import com.clx.performance.model.OrderChild;
import com.clx.performance.model.OrderGoods;
import com.clx.performance.model.PerformanceProgress;
import com.clx.performance.param.pc.carrier.PagePerformanceProgress;
import com.clx.performance.param.pc.carrier.UpdatePerformanceProgressParam;
import com.clx.performance.vo.pc.PerformanceProgressDetailVO;
import com.clx.performance.vo.pc.PerformanceProgressOperationLogVO;
import com.clx.performance.vo.pc.PerformanceProgressVO;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

import java.util.List;

/**
 * @author kavin
 * Date 2024-07-12
 * Time 16:02
 */
public interface PerformanceProgressService {
    IPage<PerformanceProgressVO> pagePerformanceProgress(PagePerformanceProgress param);

    void updateAdjustOrder(Integer adjustOrderId, Integer adjustOrderBeforeId);


    void saveOrUpdatePerformanceProgress(PerformanceProgress item);

    void updatePerformanceProgress(UpdatePerformanceProgressParam param, Long userNo, String userName);

    PerformanceProgressDetailVO getPerformanceProgressDetail(Integer id);

    List<PerformanceProgressOperationLogVO> getOperationLog(String orderNo,Integer operateType);

    void dealPerformanceProgress4OrderInfo(OrderInfoMessage data);

    List<PerformanceProgressVO> queryPerformanceProgress(List<String> orderNoList);

    void dealPerformanceProgress4OrderGoods(OrderGoods data);

    void dealPerformanceProgress4OrderChild(OrderChild data);

    SXSSFWorkbook exportPerformanceProgress(PagePerformanceProgress param);
}
