package com.clx.performance.config;

import com.clx.performance.dao.AppDao;
import com.clx.performance.enums.AppEnum;
import com.clx.performance.enums.PerformanceResultEnum;
import com.clx.performance.model.App;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @Author liruixin
 * @create 2024-01-10 13:19
 */
@Component
public class LoadAppConfig {


    @Autowired
    private AppDao appDao;

    private App app;


    public App getApp(Integer code) {
        if (app == null) {
            app = appDao.getOneByField(App::getUniqueIdentifier, code).orElseThrow(
                    PerformanceResultEnum.DATA_NOT_FIND);
        }
        return app;
    }

}
