package com.clx.performance.vo.pc.loan.carrier;

import com.clx.performance.enums.loan.OwnerLoanRecordEnum;
import com.clx.performance.enums.loan.OwnerPaymentEnum;
import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * @author kavin
 * Date 2024-01-20
 * Time 13:31
 */
@Getter
@Setter
public class OwnerPaymentVO{

    
    private Integer id;

    
    @Schema(description="货主编码")
    private String ownerUserNo;

    
    @Schema(description="货主名称")
    private String ownerUserName;

    
    @Schema(description="联系电话")
    private String mobile;

    
    @Schema(description="交易流水号（第三方）")
    private String runningWaterOpenNo;

    @Schema(description="商户流水")
    private String merchantRunningWaterNo;

    
    @Schema(description="付款单号")
    private Long paymentNo;

    
    @Schema(description="还款单号")
    private Long repaymentNo;

    @MoneyOutConvert
    @Schema(description="付款金额")
    private BigDecimal paymentBalance;

    
    @Schema(description="付款方")
    private String payment;

    
    @Schema(description="付款账户")
    private String paymentAccount;

    
    @Schema(description="收款方")
    private String payee;

    
    @Schema(description="收款账户")
    private String payeeAccount;

    
    @Schema(description="10 待付款 40 付款中 50 付款成功 60 付款失败")
    private Integer status;

    @Schema(description="待付款  付款中 付款成功 付款失败")
    private String statusMsg;

    public String getStatusMsg(){
        return OwnerPaymentEnum.Status.getMsgByCode(status);
    }

    
    @Schema(description="默认财资")
    private Integer payChannel;

    @Schema(description="支付渠道名称")
    private String payChannelMsg;

    public String getPayChannelMsg(){
        return OwnerLoanRecordEnum.PayChannel.ASSET.getMsg();
    }

    
    @Schema(description="操作时间")
    private String operateTime;

    
    @Schema(description="操作人")
    private String operateBy;

    
    @Schema(description="创建人")
    private String createBy;

    
    @Schema(description="创建时间")
    private String createTime;

    
    @Schema(description="修改时间")
    private String modifiedTime;
}
