package com.clx.performance.vo.pc.loan.carrier;

import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;

import java.math.BigDecimal;

/**
 * @author kavin
 * Date 2024-01-20
 * Time 13:31
 */
@Getter
@Setter
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class CarrierOwnerPaymentVO{

    private Integer id;
   
    @Schema(description="付款金额")
    @MoneyOutConvert
    private BigDecimal paymentBalance;

    @Schema(description="付款方")
    private String payment;

    @Schema(description="付款账户")
    private String paymentAccount;

    @Schema(description="收款方")
    private String payee;

    @Schema(description="收款账户")
    private String payeeAccount;

}
